/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AuditLogsResponsePage;
import com.datadog.api.client.v2.model.AuditLogsResponseStatus;
import com.datadog.api.client.v2.model.AuditLogsWarning;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"elapsed", "page", "request_id", "status", "warnings"})
public class AuditLogsResponseMetadata {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ELAPSED = "elapsed";
    private Long elapsed;
    public static final String JSON_PROPERTY_PAGE = "page";
    private AuditLogsResponsePage page;
    public static final String JSON_PROPERTY_REQUEST_ID = "request_id";
    private String requestId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private AuditLogsResponseStatus status;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    private List<AuditLogsWarning> warnings = null;

    public AuditLogsResponseMetadata elapsed(Long elapsed) {
        this.elapsed = elapsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="elapsed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(Long elapsed) {
        this.elapsed = elapsed;
    }

    public AuditLogsResponseMetadata page(AuditLogsResponsePage page) {
        this.page = page;
        this.unparsed |= page.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuditLogsResponsePage getPage() {
        return this.page;
    }

    public void setPage(AuditLogsResponsePage page) {
        this.page = page;
    }

    public AuditLogsResponseMetadata requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Nullable
    @JsonProperty(value="request_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public AuditLogsResponseMetadata status(AuditLogsResponseStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuditLogsResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(AuditLogsResponseStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public AuditLogsResponseMetadata warnings(List<AuditLogsWarning> warnings) {
        this.warnings = warnings;
        for (AuditLogsWarning item : warnings) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public AuditLogsResponseMetadata addWarningsItem(AuditLogsWarning warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<AuditLogsWarning>();
        }
        this.warnings.add(warningsItem);
        this.unparsed |= warningsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AuditLogsWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<AuditLogsWarning> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogsResponseMetadata auditLogsResponseMetadata = (AuditLogsResponseMetadata)o;
        return Objects.equals(this.elapsed, auditLogsResponseMetadata.elapsed) && Objects.equals(this.page, auditLogsResponseMetadata.page) && Objects.equals(this.requestId, auditLogsResponseMetadata.requestId) && Objects.equals(this.status, auditLogsResponseMetadata.status) && Objects.equals(this.warnings, auditLogsResponseMetadata.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.elapsed, this.page, this.requestId, this.status, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditLogsResponseMetadata {\n");
        sb.append("    elapsed: ").append(this.toIndentedString(this.elapsed)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

