/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=MonitorOverallStatesSerializer.class)
public class MonitorOverallStates {
    public static final MonitorOverallStates ALERT = new MonitorOverallStates("Alert");
    public static final MonitorOverallStates IGNORED = new MonitorOverallStates("Ignored");
    public static final MonitorOverallStates NO_DATA = new MonitorOverallStates("No Data");
    public static final MonitorOverallStates OK = new MonitorOverallStates("OK");
    public static final MonitorOverallStates SKIPPED = new MonitorOverallStates("Skipped");
    public static final MonitorOverallStates UNKNOWN = new MonitorOverallStates("Unknown");
    public static final MonitorOverallStates WARN = new MonitorOverallStates("Warn");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("Alert", "Ignored", "No Data", "OK", "Skipped", "Unknown", "Warn"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    MonitorOverallStates(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((MonitorOverallStates)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static MonitorOverallStates fromValue(String value) {
        return new MonitorOverallStates(value);
    }

    public static class MonitorOverallStatesSerializer
    extends StdSerializer<MonitorOverallStates> {
        public MonitorOverallStatesSerializer(Class<MonitorOverallStates> t) {
            super(t);
        }

        public MonitorOverallStatesSerializer() {
            this(null);
        }

        public void serialize(MonitorOverallStates value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

