/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsStatusRemapperType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"is_enabled", "name", "sources", "type"})
public class LogsStatusRemapper {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = new ArrayList<String>();
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsStatusRemapperType type = LogsStatusRemapperType.STATUS_REMAPPER;

    public LogsStatusRemapper() {
    }

    @JsonCreator
    public LogsStatusRemapper(@JsonProperty(required=true, value="sources") List<String> sources, @JsonProperty(required=true, value="type") LogsStatusRemapperType type) {
        this.sources = sources;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public LogsStatusRemapper isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsStatusRemapper name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsStatusRemapper sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public LogsStatusRemapper addSourcesItem(String sourcesItem) {
        this.sources.add(sourcesItem);
        return this;
    }

    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public LogsStatusRemapper type(LogsStatusRemapperType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsStatusRemapperType getType() {
        return this.type;
    }

    public void setType(LogsStatusRemapperType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsStatusRemapper logsStatusRemapper = (LogsStatusRemapper)o;
        return Objects.equals(this.isEnabled, logsStatusRemapper.isEnabled) && Objects.equals(this.name, logsStatusRemapper.name) && Objects.equals(this.sources, logsStatusRemapper.sources) && Objects.equals(this.type, logsStatusRemapper.type);
    }

    public int hashCode() {
        return Objects.hash(this.isEnabled, this.name, this.sources, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsStatusRemapper {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

