/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=SignalArchiveReasonSerializer.class)
public class SignalArchiveReason {
    public static final SignalArchiveReason NONE = new SignalArchiveReason("none");
    public static final SignalArchiveReason FALSE_POSITIVE = new SignalArchiveReason("false_positive");
    public static final SignalArchiveReason TESTING_OR_MAINTENANCE = new SignalArchiveReason("testing_or_maintenance");
    public static final SignalArchiveReason OTHER = new SignalArchiveReason("other");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("none", "false_positive", "testing_or_maintenance", "other"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    SignalArchiveReason(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((SignalArchiveReason)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static SignalArchiveReason fromValue(String value) {
        return new SignalArchiveReason(value);
    }

    public static class SignalArchiveReasonSerializer
    extends StdSerializer<SignalArchiveReason> {
        public SignalArchiveReasonSerializer(Class<SignalArchiveReason> t) {
            super(t);
        }

        public SignalArchiveReasonSerializer() {
            this(null);
        }

        public void serialize(SignalArchiveReason value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

