/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsCategoryProcessorCategory;
import com.datadog.api.v1.client.model.LogsCategoryProcessorType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"categories", "is_enabled", "name", "target", "type"})
public class LogsCategoryProcessor {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CATEGORIES = "categories";
    private List<LogsCategoryProcessorCategory> categories = new ArrayList<LogsCategoryProcessorCategory>();
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsCategoryProcessorType type = LogsCategoryProcessorType.CATEGORY_PROCESSOR;

    public LogsCategoryProcessor() {
    }

    @JsonCreator
    public LogsCategoryProcessor(@JsonProperty(required=true, value="categories") List<LogsCategoryProcessorCategory> categories, @JsonProperty(required=true, value="target") String target, @JsonProperty(required=true, value="type") LogsCategoryProcessorType type) {
        this.categories = categories;
        this.target = target;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public LogsCategoryProcessor categories(List<LogsCategoryProcessorCategory> categories) {
        this.categories = categories;
        for (LogsCategoryProcessorCategory item : categories) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsCategoryProcessor addCategoriesItem(LogsCategoryProcessorCategory categoriesItem) {
        this.categories.add(categoriesItem);
        this.unparsed |= categoriesItem.unparsed;
        return this;
    }

    @JsonProperty(value="categories")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<LogsCategoryProcessorCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(List<LogsCategoryProcessorCategory> categories) {
        this.categories = categories;
    }

    public LogsCategoryProcessor isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsCategoryProcessor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsCategoryProcessor target(String target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public LogsCategoryProcessor type(LogsCategoryProcessorType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsCategoryProcessorType getType() {
        return this.type;
    }

    public void setType(LogsCategoryProcessorType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsCategoryProcessor logsCategoryProcessor = (LogsCategoryProcessor)o;
        return Objects.equals(this.categories, logsCategoryProcessor.categories) && Objects.equals(this.isEnabled, logsCategoryProcessor.isEnabled) && Objects.equals(this.name, logsCategoryProcessor.name) && Objects.equals(this.target, logsCategoryProcessor.target) && Objects.equals(this.type, logsCategoryProcessor.type);
    }

    public int hashCode() {
        return Objects.hash(this.categories, this.isEnabled, this.name, this.target, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsCategoryProcessor {\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

