/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogQueryDefinitionGroupBy;
import com.datadog.api.v1.client.model.LogQueryDefinitionSearch;
import com.datadog.api.v1.client.model.LogsQueryCompute;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"compute", "group_by", "index", "multi_compute", "search"})
public class LogQueryDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMPUTE = "compute";
    private LogsQueryCompute compute;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private List<LogQueryDefinitionGroupBy> groupBy = null;
    public static final String JSON_PROPERTY_INDEX = "index";
    private String index;
    public static final String JSON_PROPERTY_MULTI_COMPUTE = "multi_compute";
    private List<LogsQueryCompute> multiCompute = null;
    public static final String JSON_PROPERTY_SEARCH = "search";
    private LogQueryDefinitionSearch search;

    public LogQueryDefinition compute(LogsQueryCompute compute) {
        this.compute = compute;
        this.unparsed |= compute.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="compute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsQueryCompute getCompute() {
        return this.compute;
    }

    public void setCompute(LogsQueryCompute compute) {
        this.compute = compute;
    }

    public LogQueryDefinition groupBy(List<LogQueryDefinitionGroupBy> groupBy) {
        this.groupBy = groupBy;
        for (LogQueryDefinitionGroupBy item : groupBy) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogQueryDefinition addGroupByItem(LogQueryDefinitionGroupBy groupByItem) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<LogQueryDefinitionGroupBy>();
        }
        this.groupBy.add(groupByItem);
        this.unparsed |= groupByItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogQueryDefinitionGroupBy> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<LogQueryDefinitionGroupBy> groupBy) {
        this.groupBy = groupBy;
    }

    public LogQueryDefinition index(String index) {
        this.index = index;
        return this;
    }

    @Nullable
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public LogQueryDefinition multiCompute(List<LogsQueryCompute> multiCompute) {
        this.multiCompute = multiCompute;
        for (LogsQueryCompute item : multiCompute) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogQueryDefinition addMultiComputeItem(LogsQueryCompute multiComputeItem) {
        if (this.multiCompute == null) {
            this.multiCompute = new ArrayList<LogsQueryCompute>();
        }
        this.multiCompute.add(multiComputeItem);
        this.unparsed |= multiComputeItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="multi_compute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsQueryCompute> getMultiCompute() {
        return this.multiCompute;
    }

    public void setMultiCompute(List<LogsQueryCompute> multiCompute) {
        this.multiCompute = multiCompute;
    }

    public LogQueryDefinition search(LogQueryDefinitionSearch search) {
        this.search = search;
        this.unparsed |= search.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="search")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinitionSearch getSearch() {
        return this.search;
    }

    public void setSearch(LogQueryDefinitionSearch search) {
        this.search = search;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogQueryDefinition logQueryDefinition = (LogQueryDefinition)o;
        return Objects.equals(this.compute, logQueryDefinition.compute) && Objects.equals(this.groupBy, logQueryDefinition.groupBy) && Objects.equals(this.index, logQueryDefinition.index) && Objects.equals(this.multiCompute, logQueryDefinition.multiCompute) && Objects.equals(this.search, logQueryDefinition.search);
    }

    public int hashCode() {
        return Objects.hash(this.compute, this.groupBy, this.index, this.multiCompute, this.search);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogQueryDefinition {\n");
        sb.append("    compute: ").append(this.toIndentedString(this.compute)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    multiCompute: ").append(this.toIndentedString(this.multiCompute)).append("\n");
        sb.append("    search: ").append(this.toIndentedString(this.search)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

