/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.MetricBulkConfigureTagsType;
import com.datadog.api.v2.client.model.MetricBulkTagConfigDeleteAttributes;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request object to bulk delete all tag configurations for metrics matching the given prefix.")
@JsonPropertyOrder(value={"attributes", "id", "type"})
public class MetricBulkTagConfigDelete {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private MetricBulkTagConfigDeleteAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private MetricBulkConfigureTagsType type = MetricBulkConfigureTagsType.BULK_MANAGE_TAGS;

    public MetricBulkTagConfigDelete() {
    }

    @JsonCreator
    public MetricBulkTagConfigDelete(@JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") MetricBulkConfigureTagsType type) {
        this.id = id;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public MetricBulkTagConfigDelete attributes(MetricBulkTagConfigDeleteAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetricBulkTagConfigDeleteAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(MetricBulkTagConfigDeleteAttributes attributes) {
        this.attributes = attributes;
    }

    public MetricBulkTagConfigDelete id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="kafka.lag", required=true, value="A text prefix to match against metric names.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MetricBulkTagConfigDelete type(MetricBulkConfigureTagsType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MetricBulkConfigureTagsType getType() {
        return this.type;
    }

    public void setType(MetricBulkConfigureTagsType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricBulkTagConfigDelete metricBulkTagConfigDelete = (MetricBulkTagConfigDelete)o;
        return Objects.equals(this.attributes, metricBulkTagConfigDelete.attributes) && Objects.equals(this.id, metricBulkTagConfigDelete.id) && Objects.equals(this.type, metricBulkTagConfigDelete.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricBulkTagConfigDelete {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

