/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.ApplicationKeyCreateRequest;
import com.datadog.api.v2.client.model.ApplicationKeyResponse;
import com.datadog.api.v2.client.model.ApplicationKeyUpdateRequest;
import com.datadog.api.v2.client.model.ApplicationKeysSort;
import com.datadog.api.v2.client.model.ListApplicationKeysResponse;
import com.datadog.api.v2.client.model.PartialApplicationKeyResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class ServiceAccountsApi {
    private ApiClient apiClient;

    public ServiceAccountsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ServiceAccountsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApplicationKeyResponse createServiceAccountApplicationKey(String serviceAccountId, ApplicationKeyCreateRequest body) throws ApiException {
        return this.createServiceAccountApplicationKeyWithHttpInfo(serviceAccountId, body).getData();
    }

    public CompletableFuture<ApplicationKeyResponse> createServiceAccountApplicationKeyAsync(String serviceAccountId, ApplicationKeyCreateRequest body) {
        return this.createServiceAccountApplicationKeyWithHttpInfoAsync(serviceAccountId, body).thenApply(response -> (ApplicationKeyResponse)response.getData());
    }

    public ApiResponse<ApplicationKeyResponse> createServiceAccountApplicationKeyWithHttpInfo(String serviceAccountId, ApplicationKeyCreateRequest body) throws ApiException {
        ApplicationKeyCreateRequest localVarPostBody = body;
        if (serviceAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling createServiceAccountApplicationKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createServiceAccountApplicationKey");
        }
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createServiceAccountApplicationKey");
        Invocation.Builder builder = this.apiClient.createBuilder("ServiceAccountsApi.createServiceAccountApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationKeyResponse>> createServiceAccountApplicationKeyWithHttpInfoAsync(String serviceAccountId, ApplicationKeyCreateRequest body) {
        Invocation.Builder builder;
        ApplicationKeyCreateRequest localVarPostBody = body;
        if (serviceAccountId == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling createServiceAccountApplicationKey"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createServiceAccountApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createServiceAccountApplicationKey");
        try {
            builder = this.apiClient.createBuilder("ServiceAccountsApi.createServiceAccountApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public void deleteServiceAccountApplicationKey(String serviceAccountId, String appKeyId) throws ApiException {
        this.deleteServiceAccountApplicationKeyWithHttpInfo(serviceAccountId, appKeyId);
    }

    public CompletableFuture<Void> deleteServiceAccountApplicationKeyAsync(String serviceAccountId, String appKeyId) {
        return this.deleteServiceAccountApplicationKeyWithHttpInfoAsync(serviceAccountId, appKeyId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteServiceAccountApplicationKeyWithHttpInfo(String serviceAccountId, String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (serviceAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling deleteServiceAccountApplicationKey");
        }
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling deleteServiceAccountApplicationKey");
        }
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys/{app_key_id}".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString())).replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteServiceAccountApplicationKey");
        Invocation.Builder builder = this.apiClient.createBuilder("ServiceAccountsApi.deleteServiceAccountApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteServiceAccountApplicationKeyWithHttpInfoAsync(String serviceAccountId, String appKeyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (serviceAccountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling deleteServiceAccountApplicationKey"));
            return result;
        }
        if (appKeyId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appKeyId' when calling deleteServiceAccountApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys/{app_key_id}".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString())).replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteServiceAccountApplicationKey");
        try {
            builder = this.apiClient.createBuilder("ServiceAccountsApi.deleteServiceAccountApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public PartialApplicationKeyResponse getServiceAccountApplicationKey(String serviceAccountId, String appKeyId) throws ApiException {
        return this.getServiceAccountApplicationKeyWithHttpInfo(serviceAccountId, appKeyId).getData();
    }

    public CompletableFuture<PartialApplicationKeyResponse> getServiceAccountApplicationKeyAsync(String serviceAccountId, String appKeyId) {
        return this.getServiceAccountApplicationKeyWithHttpInfoAsync(serviceAccountId, appKeyId).thenApply(response -> (PartialApplicationKeyResponse)response.getData());
    }

    public ApiResponse<PartialApplicationKeyResponse> getServiceAccountApplicationKeyWithHttpInfo(String serviceAccountId, String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (serviceAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling getServiceAccountApplicationKey");
        }
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling getServiceAccountApplicationKey");
        }
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys/{app_key_id}".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString())).replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getServiceAccountApplicationKey");
        Invocation.Builder builder = this.apiClient.createBuilder("ServiceAccountsApi.getServiceAccountApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PartialApplicationKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<PartialApplicationKeyResponse>> getServiceAccountApplicationKeyWithHttpInfoAsync(String serviceAccountId, String appKeyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (serviceAccountId == null) {
            CompletableFuture<ApiResponse<PartialApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<PartialApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling getServiceAccountApplicationKey"));
            return result;
        }
        if (appKeyId == null) {
            CompletableFuture<ApiResponse<PartialApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<PartialApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appKeyId' when calling getServiceAccountApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys/{app_key_id}".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString())).replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getServiceAccountApplicationKey");
        try {
            builder = this.apiClient.createBuilder("ServiceAccountsApi.getServiceAccountApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PartialApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<PartialApplicationKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PartialApplicationKeyResponse>(){});
    }

    public ListApplicationKeysResponse listServiceAccountApplicationKeys(String serviceAccountId) throws ApiException {
        return this.listServiceAccountApplicationKeysWithHttpInfo(serviceAccountId, new ListServiceAccountApplicationKeysOptionalParameters()).getData();
    }

    public CompletableFuture<ListApplicationKeysResponse> listServiceAccountApplicationKeysAsync(String serviceAccountId) {
        return this.listServiceAccountApplicationKeysWithHttpInfoAsync(serviceAccountId, new ListServiceAccountApplicationKeysOptionalParameters()).thenApply(response -> (ListApplicationKeysResponse)response.getData());
    }

    public ListApplicationKeysResponse listServiceAccountApplicationKeys(String serviceAccountId, ListServiceAccountApplicationKeysOptionalParameters parameters) throws ApiException {
        return this.listServiceAccountApplicationKeysWithHttpInfo(serviceAccountId, parameters).getData();
    }

    public CompletableFuture<ListApplicationKeysResponse> listServiceAccountApplicationKeysAsync(String serviceAccountId, ListServiceAccountApplicationKeysOptionalParameters parameters) {
        return this.listServiceAccountApplicationKeysWithHttpInfoAsync(serviceAccountId, parameters).thenApply(response -> (ListApplicationKeysResponse)response.getData());
    }

    public ApiResponse<ListApplicationKeysResponse> listServiceAccountApplicationKeysWithHttpInfo(String serviceAccountId, ListServiceAccountApplicationKeysOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (serviceAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling listServiceAccountApplicationKeys");
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        ApplicationKeysSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterCreatedAtStart = parameters.filterCreatedAtStart;
        String filterCreatedAtEnd = parameters.filterCreatedAtEnd;
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarHeaderParams.put("DD-OPERATION-ID", "listServiceAccountApplicationKeys");
        Invocation.Builder builder = this.apiClient.createBuilder("ServiceAccountsApi.listServiceAccountApplicationKeys", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListApplicationKeysResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListApplicationKeysResponse>> listServiceAccountApplicationKeysWithHttpInfoAsync(String serviceAccountId, ListServiceAccountApplicationKeysOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (serviceAccountId == null) {
            CompletableFuture<ApiResponse<ListApplicationKeysResponse>> result = new CompletableFuture<ApiResponse<ListApplicationKeysResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling listServiceAccountApplicationKeys"));
            return result;
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        ApplicationKeysSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterCreatedAtStart = parameters.filterCreatedAtStart;
        String filterCreatedAtEnd = parameters.filterCreatedAtEnd;
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarHeaderParams.put("DD-OPERATION-ID", "listServiceAccountApplicationKeys");
        try {
            builder = this.apiClient.createBuilder("ServiceAccountsApi.listServiceAccountApplicationKeys", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListApplicationKeysResponse>> result = new CompletableFuture<ApiResponse<ListApplicationKeysResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListApplicationKeysResponse>(){});
    }

    public PartialApplicationKeyResponse updateServiceAccountApplicationKey(String serviceAccountId, String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        return this.updateServiceAccountApplicationKeyWithHttpInfo(serviceAccountId, appKeyId, body).getData();
    }

    public CompletableFuture<PartialApplicationKeyResponse> updateServiceAccountApplicationKeyAsync(String serviceAccountId, String appKeyId, ApplicationKeyUpdateRequest body) {
        return this.updateServiceAccountApplicationKeyWithHttpInfoAsync(serviceAccountId, appKeyId, body).thenApply(response -> (PartialApplicationKeyResponse)response.getData());
    }

    public ApiResponse<PartialApplicationKeyResponse> updateServiceAccountApplicationKeyWithHttpInfo(String serviceAccountId, String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        ApplicationKeyUpdateRequest localVarPostBody = body;
        if (serviceAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling updateServiceAccountApplicationKey");
        }
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling updateServiceAccountApplicationKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateServiceAccountApplicationKey");
        }
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys/{app_key_id}".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString())).replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateServiceAccountApplicationKey");
        Invocation.Builder builder = this.apiClient.createBuilder("ServiceAccountsApi.updateServiceAccountApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PartialApplicationKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<PartialApplicationKeyResponse>> updateServiceAccountApplicationKeyWithHttpInfoAsync(String serviceAccountId, String appKeyId, ApplicationKeyUpdateRequest body) {
        Invocation.Builder builder;
        ApplicationKeyUpdateRequest localVarPostBody = body;
        if (serviceAccountId == null) {
            CompletableFuture<ApiResponse<PartialApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<PartialApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling updateServiceAccountApplicationKey"));
            return result;
        }
        if (appKeyId == null) {
            CompletableFuture<ApiResponse<PartialApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<PartialApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appKeyId' when calling updateServiceAccountApplicationKey"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<PartialApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<PartialApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateServiceAccountApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys/{app_key_id}".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString())).replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateServiceAccountApplicationKey");
        try {
            builder = this.apiClient.createBuilder("ServiceAccountsApi.updateServiceAccountApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PartialApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<PartialApplicationKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PartialApplicationKeyResponse>(){});
    }

    public static class ListServiceAccountApplicationKeysOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private ApplicationKeysSort sort;
        private String filter;
        private String filterCreatedAtStart;
        private String filterCreatedAtEnd;

        public ListServiceAccountApplicationKeysOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListServiceAccountApplicationKeysOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListServiceAccountApplicationKeysOptionalParameters sort(ApplicationKeysSort sort) {
            this.sort = sort;
            return this;
        }

        public ListServiceAccountApplicationKeysOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ListServiceAccountApplicationKeysOptionalParameters filterCreatedAtStart(String filterCreatedAtStart) {
            this.filterCreatedAtStart = filterCreatedAtStart;
            return this;
        }

        public ListServiceAccountApplicationKeysOptionalParameters filterCreatedAtEnd(String filterCreatedAtEnd) {
            this.filterCreatedAtEnd = filterCreatedAtEnd;
            return this;
        }
    }
}

