/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Number of netflow events indexed for each hour for a given organization.")
@JsonPropertyOrder(value={"hour", "indexed_events_count", "org_name", "public_id"})
public class UsageNetworkFlowsHour {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_INDEXED_EVENTS_COUNT = "indexed_events_count";
    private Long indexedEventsCount;
    public static final String JSON_PROPERTY_ORG_NAME = "org_name";
    private String orgName;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;

    public UsageNetworkFlowsHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageNetworkFlowsHour indexedEventsCount(Long indexedEventsCount) {
        this.indexedEventsCount = indexedEventsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of netflow events indexed.")
    @JsonProperty(value="indexed_events_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIndexedEventsCount() {
        return this.indexedEventsCount;
    }

    public void setIndexedEventsCount(Long indexedEventsCount) {
        this.indexedEventsCount = indexedEventsCount;
    }

    public UsageNetworkFlowsHour orgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The organization name.")
    @JsonProperty(value="org_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public UsageNetworkFlowsHour publicId(String publicId) {
        this.publicId = publicId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The organization public ID.")
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageNetworkFlowsHour usageNetworkFlowsHour = (UsageNetworkFlowsHour)o;
        return Objects.equals(this.hour, usageNetworkFlowsHour.hour) && Objects.equals(this.indexedEventsCount, usageNetworkFlowsHour.indexedEventsCount) && Objects.equals(this.orgName, usageNetworkFlowsHour.orgName) && Objects.equals(this.publicId, usageNetworkFlowsHour.publicId);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.indexedEventsCount, this.orgName, this.publicId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageNetworkFlowsHour {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    indexedEventsCount: ").append(this.toIndentedString(this.indexedEventsCount)).append("\n");
        sb.append("    orgName: ").append(this.toIndentedString(this.orgName)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

