/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SLOListResponseMetadata;
import com.datadog.api.v1.client.model.ServiceLevelObjective;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A response with one or more service level objective.")
@JsonPropertyOrder(value={"data", "errors", "metadata"})
public class SLOListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<ServiceLevelObjective> data = null;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<String> errors = null;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private SLOListResponseMetadata metadata;

    public SLOListResponse data(List<ServiceLevelObjective> data) {
        this.data = data;
        for (ServiceLevelObjective item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SLOListResponse addDataItem(ServiceLevelObjective dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<ServiceLevelObjective>();
        }
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of service level objective objects.")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ServiceLevelObjective> getData() {
        return this.data;
    }

    public void setData(List<ServiceLevelObjective> data) {
        this.data = data;
    }

    public SLOListResponse errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public SLOListResponse addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of error messages. Each endpoint documents how/whether this field is used.")
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public SLOListResponse metadata(SLOListResponseMetadata metadata) {
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOListResponseMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(SLOListResponseMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOListResponse slOListResponse = (SLOListResponse)o;
        return Objects.equals(this.data, slOListResponse.data) && Objects.equals(this.errors, slOListResponse.errors) && Objects.equals(this.metadata, slOListResponse.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.errors, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOListResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

