/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.MonitorDeviceID;
import com.datadog.api.v1.client.model.MonitorFormulaAndFunctionQueryDefinition;
import com.datadog.api.v1.client.model.MonitorOptionsAggregation;
import com.datadog.api.v1.client.model.MonitorRenotifyStatusType;
import com.datadog.api.v1.client.model.MonitorThresholdWindowOptions;
import com.datadog.api.v1.client.model.MonitorThresholds;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="List of options associated with your monitor.")
@JsonPropertyOrder(value={"aggregation", "device_ids", "enable_logs_sample", "escalation_message", "evaluation_delay", "groupby_simple_monitor", "include_tags", "locked", "min_failure_duration", "min_location_failed", "new_group_delay", "new_host_delay", "no_data_timeframe", "notify_audit", "notify_no_data", "renotify_interval", "renotify_occurrences", "renotify_statuses", "require_full_window", "silenced", "synthetics_check_id", "threshold_windows", "thresholds", "timeout_h", "variables"})
public class MonitorOptions {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private MonitorOptionsAggregation aggregation;
    public static final String JSON_PROPERTY_DEVICE_IDS = "device_ids";
    private List<MonitorDeviceID> deviceIds = null;
    public static final String JSON_PROPERTY_ENABLE_LOGS_SAMPLE = "enable_logs_sample";
    private Boolean enableLogsSample;
    public static final String JSON_PROPERTY_ESCALATION_MESSAGE = "escalation_message";
    private String escalationMessage = "none";
    public static final String JSON_PROPERTY_EVALUATION_DELAY = "evaluation_delay";
    private JsonNullable<Long> evaluationDelay = JsonNullable.undefined();
    public static final String JSON_PROPERTY_GROUPBY_SIMPLE_MONITOR = "groupby_simple_monitor";
    private Boolean groupbySimpleMonitor;
    public static final String JSON_PROPERTY_INCLUDE_TAGS = "include_tags";
    private Boolean includeTags = true;
    public static final String JSON_PROPERTY_LOCKED = "locked";
    private Boolean locked;
    public static final String JSON_PROPERTY_MIN_FAILURE_DURATION = "min_failure_duration";
    private JsonNullable<Long> minFailureDuration = JsonNullable.of((Object)0L);
    public static final String JSON_PROPERTY_MIN_LOCATION_FAILED = "min_location_failed";
    private JsonNullable<Long> minLocationFailed = JsonNullable.of((Object)1L);
    public static final String JSON_PROPERTY_NEW_GROUP_DELAY = "new_group_delay";
    private JsonNullable<Long> newGroupDelay = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NEW_HOST_DELAY = "new_host_delay";
    private JsonNullable<Long> newHostDelay = JsonNullable.of((Object)300L);
    public static final String JSON_PROPERTY_NO_DATA_TIMEFRAME = "no_data_timeframe";
    private JsonNullable<Long> noDataTimeframe = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NOTIFY_AUDIT = "notify_audit";
    private Boolean notifyAudit = false;
    public static final String JSON_PROPERTY_NOTIFY_NO_DATA = "notify_no_data";
    private Boolean notifyNoData = false;
    public static final String JSON_PROPERTY_RENOTIFY_INTERVAL = "renotify_interval";
    private JsonNullable<Long> renotifyInterval = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RENOTIFY_OCCURRENCES = "renotify_occurrences";
    private JsonNullable<Long> renotifyOccurrences = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RENOTIFY_STATUSES = "renotify_statuses";
    private JsonNullable<List<MonitorRenotifyStatusType>> renotifyStatuses = JsonNullable.undefined();
    public static final String JSON_PROPERTY_REQUIRE_FULL_WINDOW = "require_full_window";
    private Boolean requireFullWindow;
    public static final String JSON_PROPERTY_SILENCED = "silenced";
    private Map<String, Long> silenced = null;
    public static final String JSON_PROPERTY_SYNTHETICS_CHECK_ID = "synthetics_check_id";
    private JsonNullable<String> syntheticsCheckId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_THRESHOLD_WINDOWS = "threshold_windows";
    private MonitorThresholdWindowOptions thresholdWindows;
    public static final String JSON_PROPERTY_THRESHOLDS = "thresholds";
    private MonitorThresholds thresholds;
    public static final String JSON_PROPERTY_TIMEOUT_H = "timeout_h";
    private JsonNullable<Long> timeoutH = JsonNullable.undefined();
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private List<MonitorFormulaAndFunctionQueryDefinition> variables = null;

    public MonitorOptions aggregation(MonitorOptionsAggregation aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= aggregation.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorOptionsAggregation getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(MonitorOptionsAggregation aggregation) {
        this.aggregation = aggregation;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="IDs of the device the Synthetics monitor is running on.")
    @JsonProperty(value="device_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MonitorDeviceID> getDeviceIds() {
        return this.deviceIds;
    }

    public MonitorOptions enableLogsSample(Boolean enableLogsSample) {
        this.enableLogsSample = enableLogsSample;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not to send a log sample when the log monitor triggers.")
    @JsonProperty(value="enable_logs_sample")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnableLogsSample() {
        return this.enableLogsSample;
    }

    public void setEnableLogsSample(Boolean enableLogsSample) {
        this.enableLogsSample = enableLogsSample;
    }

    public MonitorOptions escalationMessage(String escalationMessage) {
        this.escalationMessage = escalationMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="We recommend using the [is_renotify](https://docs.datadoghq.com/monitors/notify/?tab=is_alert#renotify), block in the original message instead. A message to include with a re-notification. Supports the `@username` notification we allow elsewhere. Not applicable if `renotify_interval` is `None`.")
    @JsonProperty(value="escalation_message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEscalationMessage() {
        return this.escalationMessage;
    }

    public void setEscalationMessage(String escalationMessage) {
        this.escalationMessage = escalationMessage;
    }

    public MonitorOptions evaluationDelay(Long evaluationDelay) {
        this.evaluationDelay = JsonNullable.of((Object)evaluationDelay);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time (in seconds) to delay evaluation, as a non-negative integer. For example, if the value is set to `300` (5min), the timeframe is set to `last_5m` and the time is 7:00, the monitor evaluates data from 6:50 to 6:55. This is useful for AWS CloudWatch and other backfilled metrics to ensure the monitor always has data during evaluation.")
    @JsonIgnore
    public Long getEvaluationDelay() {
        return (Long)this.evaluationDelay.orElse(null);
    }

    @JsonProperty(value="evaluation_delay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getEvaluationDelay_JsonNullable() {
        return this.evaluationDelay;
    }

    @JsonProperty(value="evaluation_delay")
    public void setEvaluationDelay_JsonNullable(JsonNullable<Long> evaluationDelay) {
        this.evaluationDelay = evaluationDelay;
    }

    public void setEvaluationDelay(Long evaluationDelay) {
        this.evaluationDelay = JsonNullable.of((Object)evaluationDelay);
    }

    public MonitorOptions groupbySimpleMonitor(Boolean groupbySimpleMonitor) {
        this.groupbySimpleMonitor = groupbySimpleMonitor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the log alert monitor triggers a single alert or multiple alerts when any group breaches a threshold.")
    @JsonProperty(value="groupby_simple_monitor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupbySimpleMonitor() {
        return this.groupbySimpleMonitor;
    }

    public void setGroupbySimpleMonitor(Boolean groupbySimpleMonitor) {
        this.groupbySimpleMonitor = groupbySimpleMonitor;
    }

    public MonitorOptions includeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Boolean indicating whether notifications from this monitor automatically inserts its triggering tags into the title.  **Examples** - If `True`, `[Triggered on {host:h1}] Monitor Title` - If `False`, `[Triggered] Monitor Title`")
    @JsonProperty(value="include_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public MonitorOptions locked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the monitor is locked (only editable by creator and admins).")
    @JsonProperty(value="locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public MonitorOptions minFailureDuration(Long minFailureDuration) {
        this.minFailureDuration = JsonNullable.of((Object)minFailureDuration);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="How long the test should be in failure before alerting (integer, number of seconds, max 7200).")
    @JsonIgnore
    public Long getMinFailureDuration() {
        return (Long)this.minFailureDuration.orElse(null);
    }

    @JsonProperty(value="min_failure_duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getMinFailureDuration_JsonNullable() {
        return this.minFailureDuration;
    }

    @JsonProperty(value="min_failure_duration")
    public void setMinFailureDuration_JsonNullable(JsonNullable<Long> minFailureDuration) {
        this.minFailureDuration = minFailureDuration;
    }

    public void setMinFailureDuration(Long minFailureDuration) {
        this.minFailureDuration = JsonNullable.of((Object)minFailureDuration);
    }

    public MonitorOptions minLocationFailed(Long minLocationFailed) {
        this.minLocationFailed = JsonNullable.of((Object)minLocationFailed);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum number of locations in failure at the same time during at least one moment in the `min_failure_duration` period (`min_location_failed` and `min_failure_duration` are part of the advanced alerting rules - integer, >= 1).")
    @JsonIgnore
    public Long getMinLocationFailed() {
        return (Long)this.minLocationFailed.orElse(null);
    }

    @JsonProperty(value="min_location_failed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getMinLocationFailed_JsonNullable() {
        return this.minLocationFailed;
    }

    @JsonProperty(value="min_location_failed")
    public void setMinLocationFailed_JsonNullable(JsonNullable<Long> minLocationFailed) {
        this.minLocationFailed = minLocationFailed;
    }

    public void setMinLocationFailed(Long minLocationFailed) {
        this.minLocationFailed = JsonNullable.of((Object)minLocationFailed);
    }

    public MonitorOptions newGroupDelay(Long newGroupDelay) {
        this.newGroupDelay = JsonNullable.of((Object)newGroupDelay);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time (in seconds) to skip evaluations for new groups.  For example, this option can be used to skip evaluations for new hosts while they initialize.  Must be a non negative integer.")
    @JsonIgnore
    public Long getNewGroupDelay() {
        return (Long)this.newGroupDelay.orElse(null);
    }

    @JsonProperty(value="new_group_delay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getNewGroupDelay_JsonNullable() {
        return this.newGroupDelay;
    }

    @JsonProperty(value="new_group_delay")
    public void setNewGroupDelay_JsonNullable(JsonNullable<Long> newGroupDelay) {
        this.newGroupDelay = newGroupDelay;
    }

    public void setNewGroupDelay(Long newGroupDelay) {
        this.newGroupDelay = JsonNullable.of((Object)newGroupDelay);
    }

    public MonitorOptions newHostDelay(Long newHostDelay) {
        this.newHostDelay = JsonNullable.of((Object)newHostDelay);
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="Time (in seconds) to allow a host to boot and applications to fully start before starting the evaluation of monitor results. Should be a non negative integer.  Use new_group_delay instead.")
    @JsonIgnore
    public Long getNewHostDelay() {
        return (Long)this.newHostDelay.orElse(null);
    }

    @JsonProperty(value="new_host_delay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getNewHostDelay_JsonNullable() {
        return this.newHostDelay;
    }

    @JsonProperty(value="new_host_delay")
    public void setNewHostDelay_JsonNullable(JsonNullable<Long> newHostDelay) {
        this.newHostDelay = newHostDelay;
    }

    public void setNewHostDelay(Long newHostDelay) {
        this.newHostDelay = JsonNullable.of((Object)newHostDelay);
    }

    public MonitorOptions noDataTimeframe(Long noDataTimeframe) {
        this.noDataTimeframe = JsonNullable.of((Object)noDataTimeframe);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of minutes before a monitor notifies after data stops reporting. Datadog recommends at least 2x the monitor timeframe for query alerts or 2 minutes for service checks. If omitted, 2x the evaluation timeframe is used for query alerts, and 24 hours is used for service checks.")
    @JsonIgnore
    public Long getNoDataTimeframe() {
        return (Long)this.noDataTimeframe.orElse(null);
    }

    @JsonProperty(value="no_data_timeframe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getNoDataTimeframe_JsonNullable() {
        return this.noDataTimeframe;
    }

    @JsonProperty(value="no_data_timeframe")
    public void setNoDataTimeframe_JsonNullable(JsonNullable<Long> noDataTimeframe) {
        this.noDataTimeframe = noDataTimeframe;
    }

    public void setNoDataTimeframe(Long noDataTimeframe) {
        this.noDataTimeframe = JsonNullable.of((Object)noDataTimeframe);
    }

    public MonitorOptions notifyAudit(Boolean notifyAudit) {
        this.notifyAudit = notifyAudit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Boolean indicating whether tagged users is notified on changes to this monitor.")
    @JsonProperty(value="notify_audit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNotifyAudit() {
        return this.notifyAudit;
    }

    public void setNotifyAudit(Boolean notifyAudit) {
        this.notifyAudit = notifyAudit;
    }

    public MonitorOptions notifyNoData(Boolean notifyNoData) {
        this.notifyNoData = notifyNoData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Boolean indicating whether this monitor notifies when data stops reporting.")
    @JsonProperty(value="notify_no_data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNotifyNoData() {
        return this.notifyNoData;
    }

    public void setNotifyNoData(Boolean notifyNoData) {
        this.notifyNoData = notifyNoData;
    }

    public MonitorOptions renotifyInterval(Long renotifyInterval) {
        this.renotifyInterval = JsonNullable.of((Object)renotifyInterval);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of minutes after the last notification before a monitor re-notifies on the current status. It only re-notifies if it\u2019s not resolved.")
    @JsonIgnore
    public Long getRenotifyInterval() {
        return (Long)this.renotifyInterval.orElse(null);
    }

    @JsonProperty(value="renotify_interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getRenotifyInterval_JsonNullable() {
        return this.renotifyInterval;
    }

    @JsonProperty(value="renotify_interval")
    public void setRenotifyInterval_JsonNullable(JsonNullable<Long> renotifyInterval) {
        this.renotifyInterval = renotifyInterval;
    }

    public void setRenotifyInterval(Long renotifyInterval) {
        this.renotifyInterval = JsonNullable.of((Object)renotifyInterval);
    }

    public MonitorOptions renotifyOccurrences(Long renotifyOccurrences) {
        this.renotifyOccurrences = JsonNullable.of((Object)renotifyOccurrences);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times re-notification messages should be sent on the current status at the provided re-notification interval.")
    @JsonIgnore
    public Long getRenotifyOccurrences() {
        return (Long)this.renotifyOccurrences.orElse(null);
    }

    @JsonProperty(value="renotify_occurrences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getRenotifyOccurrences_JsonNullable() {
        return this.renotifyOccurrences;
    }

    @JsonProperty(value="renotify_occurrences")
    public void setRenotifyOccurrences_JsonNullable(JsonNullable<Long> renotifyOccurrences) {
        this.renotifyOccurrences = renotifyOccurrences;
    }

    public void setRenotifyOccurrences(Long renotifyOccurrences) {
        this.renotifyOccurrences = JsonNullable.of((Object)renotifyOccurrences);
    }

    public MonitorOptions renotifyStatuses(List<MonitorRenotifyStatusType> renotifyStatuses) {
        this.renotifyStatuses = JsonNullable.of(renotifyStatuses);
        return this;
    }

    public MonitorOptions addRenotifyStatusesItem(MonitorRenotifyStatusType renotifyStatusesItem) {
        if (this.renotifyStatuses == null || !this.renotifyStatuses.isPresent()) {
            this.renotifyStatuses = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.renotifyStatuses.get()).add(renotifyStatusesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The types of monitor statuses for which re-notification messages are sent.")
    @JsonIgnore
    public List<MonitorRenotifyStatusType> getRenotifyStatuses() {
        return (List)this.renotifyStatuses.orElse(null);
    }

    @JsonProperty(value="renotify_statuses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<MonitorRenotifyStatusType>> getRenotifyStatuses_JsonNullable() {
        return this.renotifyStatuses;
    }

    @JsonProperty(value="renotify_statuses")
    public void setRenotifyStatuses_JsonNullable(JsonNullable<List<MonitorRenotifyStatusType>> renotifyStatuses) {
        this.renotifyStatuses = renotifyStatuses;
    }

    public void setRenotifyStatuses(List<MonitorRenotifyStatusType> renotifyStatuses) {
        this.renotifyStatuses = JsonNullable.of(renotifyStatuses);
    }

    public MonitorOptions requireFullWindow(Boolean requireFullWindow) {
        this.requireFullWindow = requireFullWindow;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Boolean indicating whether this monitor needs a full window of data before it\u2019s evaluated. We highly recommend you set this to `false` for sparse metrics, otherwise some evaluations are skipped. Default is false.")
    @JsonProperty(value="require_full_window")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequireFullWindow() {
        return this.requireFullWindow;
    }

    public void setRequireFullWindow(Boolean requireFullWindow) {
        this.requireFullWindow = requireFullWindow;
    }

    public MonitorOptions silenced(Map<String, Long> silenced) {
        this.silenced = silenced;
        return this;
    }

    public MonitorOptions putSilencedItem(String key, Long silencedItem) {
        if (this.silenced == null) {
            this.silenced = new HashMap<String, Long>();
        }
        this.silenced.put(key, silencedItem);
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="Information about the downtime applied to the monitor.")
    @JsonProperty(value="silenced")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Long> getSilenced() {
        return this.silenced;
    }

    public void setSilenced(Map<String, Long> silenced) {
        this.silenced = silenced;
    }

    public MonitorOptions syntheticsCheckId(String syntheticsCheckId) {
        this.syntheticsCheckId = JsonNullable.of((Object)syntheticsCheckId);
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="ID of the corresponding Synthetic check.")
    @JsonIgnore
    public String getSyntheticsCheckId() {
        return (String)this.syntheticsCheckId.orElse(null);
    }

    @JsonProperty(value="synthetics_check_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSyntheticsCheckId_JsonNullable() {
        return this.syntheticsCheckId;
    }

    @JsonProperty(value="synthetics_check_id")
    public void setSyntheticsCheckId_JsonNullable(JsonNullable<String> syntheticsCheckId) {
        this.syntheticsCheckId = syntheticsCheckId;
    }

    public void setSyntheticsCheckId(String syntheticsCheckId) {
        this.syntheticsCheckId = JsonNullable.of((Object)syntheticsCheckId);
    }

    public MonitorOptions thresholdWindows(MonitorThresholdWindowOptions thresholdWindows) {
        this.thresholdWindows = thresholdWindows;
        this.unparsed |= thresholdWindows.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="threshold_windows")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorThresholdWindowOptions getThresholdWindows() {
        return this.thresholdWindows;
    }

    public void setThresholdWindows(MonitorThresholdWindowOptions thresholdWindows) {
        this.thresholdWindows = thresholdWindows;
    }

    public MonitorOptions thresholds(MonitorThresholds thresholds) {
        this.thresholds = thresholds;
        this.unparsed |= thresholds.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="thresholds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorThresholds getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(MonitorThresholds thresholds) {
        this.thresholds = thresholds;
    }

    public MonitorOptions timeoutH(Long timeoutH) {
        this.timeoutH = JsonNullable.of((Object)timeoutH);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of hours of the monitor not reporting data before it automatically resolves from a triggered state. The minimum allowed value is 0 hours. The maximum allowed value is 24 hours.")
    @JsonIgnore
    public Long getTimeoutH() {
        return (Long)this.timeoutH.orElse(null);
    }

    @JsonProperty(value="timeout_h")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getTimeoutH_JsonNullable() {
        return this.timeoutH;
    }

    @JsonProperty(value="timeout_h")
    public void setTimeoutH_JsonNullable(JsonNullable<Long> timeoutH) {
        this.timeoutH = timeoutH;
    }

    public void setTimeoutH(Long timeoutH) {
        this.timeoutH = JsonNullable.of((Object)timeoutH);
    }

    public MonitorOptions variables(List<MonitorFormulaAndFunctionQueryDefinition> variables) {
        this.variables = variables;
        for (MonitorFormulaAndFunctionQueryDefinition item : variables) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public MonitorOptions addVariablesItem(MonitorFormulaAndFunctionQueryDefinition variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<MonitorFormulaAndFunctionQueryDefinition>();
        }
        this.variables.add(variablesItem);
        this.unparsed |= variablesItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of requests that can be used in the monitor query. **This feature is currently in beta.**")
    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MonitorFormulaAndFunctionQueryDefinition> getVariables() {
        return this.variables;
    }

    public void setVariables(List<MonitorFormulaAndFunctionQueryDefinition> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorOptions monitorOptions = (MonitorOptions)o;
        return Objects.equals(this.aggregation, monitorOptions.aggregation) && Objects.equals(this.deviceIds, monitorOptions.deviceIds) && Objects.equals(this.enableLogsSample, monitorOptions.enableLogsSample) && Objects.equals(this.escalationMessage, monitorOptions.escalationMessage) && Objects.equals(this.evaluationDelay, monitorOptions.evaluationDelay) && Objects.equals(this.groupbySimpleMonitor, monitorOptions.groupbySimpleMonitor) && Objects.equals(this.includeTags, monitorOptions.includeTags) && Objects.equals(this.locked, monitorOptions.locked) && Objects.equals(this.minFailureDuration, monitorOptions.minFailureDuration) && Objects.equals(this.minLocationFailed, monitorOptions.minLocationFailed) && Objects.equals(this.newGroupDelay, monitorOptions.newGroupDelay) && Objects.equals(this.newHostDelay, monitorOptions.newHostDelay) && Objects.equals(this.noDataTimeframe, monitorOptions.noDataTimeframe) && Objects.equals(this.notifyAudit, monitorOptions.notifyAudit) && Objects.equals(this.notifyNoData, monitorOptions.notifyNoData) && Objects.equals(this.renotifyInterval, monitorOptions.renotifyInterval) && Objects.equals(this.renotifyOccurrences, monitorOptions.renotifyOccurrences) && Objects.equals(this.renotifyStatuses, monitorOptions.renotifyStatuses) && Objects.equals(this.requireFullWindow, monitorOptions.requireFullWindow) && Objects.equals(this.silenced, monitorOptions.silenced) && Objects.equals(this.syntheticsCheckId, monitorOptions.syntheticsCheckId) && Objects.equals(this.thresholdWindows, monitorOptions.thresholdWindows) && Objects.equals(this.thresholds, monitorOptions.thresholds) && Objects.equals(this.timeoutH, monitorOptions.timeoutH) && Objects.equals(this.variables, monitorOptions.variables);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.deviceIds, this.enableLogsSample, this.escalationMessage, this.evaluationDelay, this.groupbySimpleMonitor, this.includeTags, this.locked, this.minFailureDuration, this.minLocationFailed, this.newGroupDelay, this.newHostDelay, this.noDataTimeframe, this.notifyAudit, this.notifyNoData, this.renotifyInterval, this.renotifyOccurrences, this.renotifyStatuses, this.requireFullWindow, this.silenced, this.syntheticsCheckId, this.thresholdWindows, this.thresholds, this.timeoutH, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitorOptions {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    deviceIds: ").append(this.toIndentedString(this.deviceIds)).append("\n");
        sb.append("    enableLogsSample: ").append(this.toIndentedString(this.enableLogsSample)).append("\n");
        sb.append("    escalationMessage: ").append(this.toIndentedString(this.escalationMessage)).append("\n");
        sb.append("    evaluationDelay: ").append(this.toIndentedString(this.evaluationDelay)).append("\n");
        sb.append("    groupbySimpleMonitor: ").append(this.toIndentedString(this.groupbySimpleMonitor)).append("\n");
        sb.append("    includeTags: ").append(this.toIndentedString(this.includeTags)).append("\n");
        sb.append("    locked: ").append(this.toIndentedString(this.locked)).append("\n");
        sb.append("    minFailureDuration: ").append(this.toIndentedString(this.minFailureDuration)).append("\n");
        sb.append("    minLocationFailed: ").append(this.toIndentedString(this.minLocationFailed)).append("\n");
        sb.append("    newGroupDelay: ").append(this.toIndentedString(this.newGroupDelay)).append("\n");
        sb.append("    newHostDelay: ").append(this.toIndentedString(this.newHostDelay)).append("\n");
        sb.append("    noDataTimeframe: ").append(this.toIndentedString(this.noDataTimeframe)).append("\n");
        sb.append("    notifyAudit: ").append(this.toIndentedString(this.notifyAudit)).append("\n");
        sb.append("    notifyNoData: ").append(this.toIndentedString(this.notifyNoData)).append("\n");
        sb.append("    renotifyInterval: ").append(this.toIndentedString(this.renotifyInterval)).append("\n");
        sb.append("    renotifyOccurrences: ").append(this.toIndentedString(this.renotifyOccurrences)).append("\n");
        sb.append("    renotifyStatuses: ").append(this.toIndentedString(this.renotifyStatuses)).append("\n");
        sb.append("    requireFullWindow: ").append(this.toIndentedString(this.requireFullWindow)).append("\n");
        sb.append("    silenced: ").append(this.toIndentedString(this.silenced)).append("\n");
        sb.append("    syntheticsCheckId: ").append(this.toIndentedString(this.syntheticsCheckId)).append("\n");
        sb.append("    thresholdWindows: ").append(this.toIndentedString(this.thresholdWindows)).append("\n");
        sb.append("    thresholds: ").append(this.toIndentedString(this.thresholds)).append("\n");
        sb.append("    timeoutH: ").append(this.toIndentedString(this.timeoutH)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

