/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsArithmeticProcessorType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Use the Arithmetic Processor to add a new attribute (without spaces or special characters in the new attribute name) to a log with the result of the provided formula. This enables you to remap different time attributes with different units into a single attribute, or to compute operations on attributes within the same log.  The formula can use parentheses and the basic arithmetic operators `-`, `+`, `*`, `/`.  By default, the calculation is skipped if an attribute is missing. Select \u201cReplace missing attribute by 0\u201d to automatically populate missing attribute values with 0 to ensure that the calculation is done. An attribute is missing if it is not found in the log attributes, or if it cannot be converted to a number.  *Notes*:  - The operator `-` needs to be space split in the formula as it can also be contained in attribute names. - If the target attribute already exists, it is overwritten by the result of the formula. - Results are rounded up to the 9th decimal. For example, if the result of the formula is `0.1234567891`,   the actual value stored for the attribute is `0.123456789`. - If you need to scale a unit of measure,   see [Scale Filter](https://docs.datadoghq.com/logs/log_configuration/parsing/?tab=filter#matcher-and-filter).")
@JsonPropertyOrder(value={"expression", "is_enabled", "is_replace_missing", "name", "target", "type"})
public class LogsArithmeticProcessor {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private String expression;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_IS_REPLACE_MISSING = "is_replace_missing";
    private Boolean isReplaceMissing = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsArithmeticProcessorType type = LogsArithmeticProcessorType.ARITHMETIC_PROCESSOR;

    public LogsArithmeticProcessor() {
    }

    @JsonCreator
    public LogsArithmeticProcessor(@JsonProperty(required=true, value="expression") String expression, @JsonProperty(required=true, value="target") String target, @JsonProperty(required=true, value="type") LogsArithmeticProcessorType type) {
        this.expression = expression;
        this.target = target;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public LogsArithmeticProcessor expression(String expression) {
        this.expression = expression;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="Arithmetic operation between one or more log attributes.")
    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public LogsArithmeticProcessor isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the processor is enabled.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsArithmeticProcessor isReplaceMissing(Boolean isReplaceMissing) {
        this.isReplaceMissing = isReplaceMissing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `true`, it replaces all missing attributes of expression by `0`, `false` skip the operation if an attribute is missing.")
    @JsonProperty(value="is_replace_missing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsReplaceMissing() {
        return this.isReplaceMissing;
    }

    public void setIsReplaceMissing(Boolean isReplaceMissing) {
        this.isReplaceMissing = isReplaceMissing;
    }

    public LogsArithmeticProcessor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the processor.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsArithmeticProcessor target(String target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="Name of the attribute that contains the result of the arithmetic operation.")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public LogsArithmeticProcessor type(LogsArithmeticProcessorType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsArithmeticProcessorType getType() {
        return this.type;
    }

    public void setType(LogsArithmeticProcessorType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsArithmeticProcessor logsArithmeticProcessor = (LogsArithmeticProcessor)o;
        return Objects.equals(this.expression, logsArithmeticProcessor.expression) && Objects.equals(this.isEnabled, logsArithmeticProcessor.isEnabled) && Objects.equals(this.isReplaceMissing, logsArithmeticProcessor.isReplaceMissing) && Objects.equals(this.name, logsArithmeticProcessor.name) && Objects.equals(this.target, logsArithmeticProcessor.target) && Objects.equals(this.type, logsArithmeticProcessor.type);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.isEnabled, this.isReplaceMissing, this.name, this.target, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsArithmeticProcessor {\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    isReplaceMissing: ").append(this.toIndentedString(this.isReplaceMissing)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

