/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Number of active NPM hosts for each hour for a given organization.")
@JsonPropertyOrder(value={"host_count", "hour"})
public class UsageNetworkHostsHour {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HOST_COUNT = "host_count";
    private Long hostCount;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;

    public UsageNetworkHostsHour hostCount(Long hostCount) {
        this.hostCount = hostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of active NPM hosts.")
    @JsonProperty(value="host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHostCount() {
        return this.hostCount;
    }

    public void setHostCount(Long hostCount) {
        this.hostCount = hostCount;
    }

    public UsageNetworkHostsHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageNetworkHostsHour usageNetworkHostsHour = (UsageNetworkHostsHour)o;
        return Objects.equals(this.hostCount, usageNetworkHostsHour.hostCount) && Objects.equals(this.hour, usageNetworkHostsHour.hour);
    }

    public int hashCode() {
        return Objects.hash(this.hostCount, this.hour);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageNetworkHostsHour {\n");
        sb.append("    hostCount: ").append(this.toIndentedString(this.hostCount)).append("\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

