/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsAssertion;
import com.datadog.api.v1.client.model.SyntheticsBrowserVariable;
import com.datadog.api.v1.client.model.SyntheticsConfigVariable;
import com.datadog.api.v1.client.model.SyntheticsTestRequest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Configuration object for a Synthetic browser test.")
@JsonPropertyOrder(value={"assertions", "configVariables", "request", "setCookie", "variables"})
public class SyntheticsBrowserTestConfig {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ASSERTIONS = "assertions";
    private List<SyntheticsAssertion> assertions = new ArrayList<SyntheticsAssertion>();
    public static final String JSON_PROPERTY_CONFIG_VARIABLES = "configVariables";
    private List<SyntheticsConfigVariable> configVariables = null;
    public static final String JSON_PROPERTY_REQUEST = "request";
    private SyntheticsTestRequest request;
    public static final String JSON_PROPERTY_SET_COOKIE = "setCookie";
    private String setCookie;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private List<SyntheticsBrowserVariable> variables = null;

    public SyntheticsBrowserTestConfig() {
    }

    @JsonCreator
    public SyntheticsBrowserTestConfig(@JsonProperty(required=true, value="assertions") List<SyntheticsAssertion> assertions, @JsonProperty(required=true, value="request") SyntheticsTestRequest request) {
        this.assertions = assertions;
        this.request = request;
        this.unparsed |= request.unparsed;
    }

    public SyntheticsBrowserTestConfig assertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
        for (SyntheticsAssertion item : assertions) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsBrowserTestConfig addAssertionsItem(SyntheticsAssertion assertionsItem) {
        this.assertions.add(assertionsItem);
        this.unparsed |= assertionsItem.unparsed;
        return this;
    }

    @ApiModelProperty(example="[]", required=true, value="Array of assertions used for the test.")
    @JsonProperty(value="assertions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SyntheticsAssertion> getAssertions() {
        return this.assertions;
    }

    public void setAssertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
    }

    public SyntheticsBrowserTestConfig configVariables(List<SyntheticsConfigVariable> configVariables) {
        this.configVariables = configVariables;
        for (SyntheticsConfigVariable item : configVariables) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsBrowserTestConfig addConfigVariablesItem(SyntheticsConfigVariable configVariablesItem) {
        if (this.configVariables == null) {
            this.configVariables = new ArrayList<SyntheticsConfigVariable>();
        }
        this.configVariables.add(configVariablesItem);
        this.unparsed |= configVariablesItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of variables used for the test.")
    @JsonProperty(value="configVariables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsConfigVariable> getConfigVariables() {
        return this.configVariables;
    }

    public void setConfigVariables(List<SyntheticsConfigVariable> configVariables) {
        this.configVariables = configVariables;
    }

    public SyntheticsBrowserTestConfig request(SyntheticsTestRequest request) {
        this.request = request;
        this.unparsed |= request.unparsed;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsTestRequest getRequest() {
        return this.request;
    }

    public void setRequest(SyntheticsTestRequest request) {
        this.request = request;
    }

    public SyntheticsBrowserTestConfig setCookie(String setCookie) {
        this.setCookie = setCookie;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cookies to be used for the request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.")
    @JsonProperty(value="setCookie")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSetCookie() {
        return this.setCookie;
    }

    public void setSetCookie(String setCookie) {
        this.setCookie = setCookie;
    }

    public SyntheticsBrowserTestConfig variables(List<SyntheticsBrowserVariable> variables) {
        this.variables = variables;
        for (SyntheticsBrowserVariable item : variables) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsBrowserTestConfig addVariablesItem(SyntheticsBrowserVariable variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<SyntheticsBrowserVariable>();
        }
        this.variables.add(variablesItem);
        this.unparsed |= variablesItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of variables used for the test steps.")
    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsBrowserVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<SyntheticsBrowserVariable> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsBrowserTestConfig syntheticsBrowserTestConfig = (SyntheticsBrowserTestConfig)o;
        return Objects.equals(this.assertions, syntheticsBrowserTestConfig.assertions) && Objects.equals(this.configVariables, syntheticsBrowserTestConfig.configVariables) && Objects.equals(this.request, syntheticsBrowserTestConfig.request) && Objects.equals(this.setCookie, syntheticsBrowserTestConfig.setCookie) && Objects.equals(this.variables, syntheticsBrowserTestConfig.variables);
    }

    public int hashCode() {
        return Objects.hash(this.assertions, this.configVariables, this.request, this.setCookie, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsBrowserTestConfig {\n");
        sb.append("    assertions: ").append(this.toIndentedString(this.assertions)).append("\n");
        sb.append("    configVariables: ").append(this.toIndentedString(this.configVariables)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    setCookie: ").append(this.toIndentedString(this.setCookie)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

