/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The object containing all signal attributes and their associated values.")
@JsonPropertyOrder(value={"attributes", "message", "tags", "timestamp"})
public class SecurityMonitoringSignalAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, Object> attributes = null;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<Object> tags = null;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private OffsetDateTime timestamp;

    public SecurityMonitoringSignalAttributes attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public SecurityMonitoringSignalAttributes putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"workflow\":{\"first_seen\":\"2020-06-23T14:46:01.000Z\",\"last_seen\":\"2020-06-23T14:46:49.000Z\",\"rule\":{\"id\":\"0f5-e0c-805\",\"name\":\"Brute Force Attack Grouped By User \",\"version\":12}}}", value="A JSON object of attributes in the security signal.")
    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public SecurityMonitoringSignalAttributes message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Detect Account Take Over (ATO) through brute force attempts", value="The message in the security signal defined by the rule that generated the signal.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SecurityMonitoringSignalAttributes tags(List<Object> tags) {
        this.tags = tags;
        return this;
    }

    public SecurityMonitoringSignalAttributes addTagsItem(Object tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<Object>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"security:attack\",\"technique:T1110-brute-force\"]", value="An array of tags associated with the security signal.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getTags() {
        return this.tags;
    }

    public void setTags(List<Object> tags) {
        this.tags = tags;
    }

    public SecurityMonitoringSignalAttributes timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-01-02T09:42:36.320Z", value="The timestamp of the security signal.")
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringSignalAttributes securityMonitoringSignalAttributes = (SecurityMonitoringSignalAttributes)o;
        return Objects.equals(this.attributes, securityMonitoringSignalAttributes.attributes) && Objects.equals(this.message, securityMonitoringSignalAttributes.message) && Objects.equals(this.tags, securityMonitoringSignalAttributes.tags) && Objects.equals(this.timestamp, securityMonitoringSignalAttributes.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.message, this.tags, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringSignalAttributes {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

