/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.SecurityMonitoringRuleQueryAggregation;
import com.datadog.api.v2.client.model.SecurityMonitoringRuntimeAgentRule;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Query for matching rule.")
@JsonPropertyOrder(value={"agentRule", "aggregation", "distinctFields", "groupByFields", "metric", "name", "query"})
public class SecurityMonitoringRuleQueryCreate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGENT_RULE = "agentRule";
    private SecurityMonitoringRuntimeAgentRule agentRule;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private SecurityMonitoringRuleQueryAggregation aggregation;
    public static final String JSON_PROPERTY_DISTINCT_FIELDS = "distinctFields";
    private List<String> distinctFields = null;
    public static final String JSON_PROPERTY_GROUP_BY_FIELDS = "groupByFields";
    private List<String> groupByFields = null;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;

    public SecurityMonitoringRuleQueryCreate() {
    }

    @JsonCreator
    public SecurityMonitoringRuleQueryCreate(@JsonProperty(required=true, value="query") String query) {
        this.query = query;
    }

    public SecurityMonitoringRuleQueryCreate agentRule(SecurityMonitoringRuntimeAgentRule agentRule) {
        this.agentRule = agentRule;
        this.unparsed |= agentRule.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="agentRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuntimeAgentRule getAgentRule() {
        return this.agentRule;
    }

    public void setAgentRule(SecurityMonitoringRuntimeAgentRule agentRule) {
        this.agentRule = agentRule;
    }

    public SecurityMonitoringRuleQueryCreate aggregation(SecurityMonitoringRuleQueryAggregation aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleQueryAggregation getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(SecurityMonitoringRuleQueryAggregation aggregation) {
        if (!aggregation.isValid()) {
            this.unparsed = true;
        }
        this.aggregation = aggregation;
    }

    public SecurityMonitoringRuleQueryCreate distinctFields(List<String> distinctFields) {
        this.distinctFields = distinctFields;
        return this;
    }

    public SecurityMonitoringRuleQueryCreate addDistinctFieldsItem(String distinctFieldsItem) {
        if (this.distinctFields == null) {
            this.distinctFields = new ArrayList<String>();
        }
        this.distinctFields.add(distinctFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Field for which the cardinality is measured. Sent as an array.")
    @JsonProperty(value="distinctFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDistinctFields() {
        return this.distinctFields;
    }

    public void setDistinctFields(List<String> distinctFields) {
        this.distinctFields = distinctFields;
    }

    public SecurityMonitoringRuleQueryCreate groupByFields(List<String> groupByFields) {
        this.groupByFields = groupByFields;
        return this;
    }

    public SecurityMonitoringRuleQueryCreate addGroupByFieldsItem(String groupByFieldsItem) {
        if (this.groupByFields == null) {
            this.groupByFields = new ArrayList<String>();
        }
        this.groupByFields.add(groupByFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Fields to group by.")
    @JsonProperty(value="groupByFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroupByFields() {
        return this.groupByFields;
    }

    public void setGroupByFields(List<String> groupByFields) {
        this.groupByFields = groupByFields;
    }

    public SecurityMonitoringRuleQueryCreate metric(String metric) {
        this.metric = metric;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The target field to aggregate over when using the sum or max aggregations.")
    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public SecurityMonitoringRuleQueryCreate name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the query.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityMonitoringRuleQueryCreate query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="a > 3", required=true, value="Query to run on logs.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringRuleQueryCreate securityMonitoringRuleQueryCreate = (SecurityMonitoringRuleQueryCreate)o;
        return Objects.equals(this.agentRule, securityMonitoringRuleQueryCreate.agentRule) && Objects.equals(this.aggregation, securityMonitoringRuleQueryCreate.aggregation) && Objects.equals(this.distinctFields, securityMonitoringRuleQueryCreate.distinctFields) && Objects.equals(this.groupByFields, securityMonitoringRuleQueryCreate.groupByFields) && Objects.equals(this.metric, securityMonitoringRuleQueryCreate.metric) && Objects.equals(this.name, securityMonitoringRuleQueryCreate.name) && Objects.equals(this.query, securityMonitoringRuleQueryCreate.query);
    }

    public int hashCode() {
        return Objects.hash(this.agentRule, this.aggregation, this.distinctFields, this.groupByFields, this.metric, this.name, this.query);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringRuleQueryCreate {\n");
        sb.append("    agentRule: ").append(this.toIndentedString(this.agentRule)).append("\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    distinctFields: ").append(this.toIndentedString(this.distinctFields)).append("\n");
        sb.append("    groupByFields: ").append(this.toIndentedString(this.groupByFields)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

