/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.LogsAggregationFunction;
import com.datadog.api.v2.client.model.LogsComputeType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A compute rule to compute metrics or timeseries")
@JsonPropertyOrder(value={"aggregation", "interval", "metric", "type"})
public class LogsCompute {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private LogsAggregationFunction aggregation;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private String interval;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsComputeType type = LogsComputeType.TOTAL;

    public LogsCompute() {
    }

    @JsonCreator
    public LogsCompute(@JsonProperty(required=true, value="aggregation") LogsAggregationFunction aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
    }

    public LogsCompute aggregation(LogsAggregationFunction aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsAggregationFunction getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(LogsAggregationFunction aggregation) {
        if (!aggregation.isValid()) {
            this.unparsed = true;
        }
        this.aggregation = aggregation;
    }

    public LogsCompute interval(String interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5m", value="The time buckets' size (only used for type=timeseries) Defaults to a resolution of 150 points")
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public LogsCompute metric(String metric) {
        this.metric = metric;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="@duration", value="The metric to use")
    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public LogsCompute type(LogsComputeType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsComputeType getType() {
        return this.type;
    }

    public void setType(LogsComputeType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsCompute logsCompute = (LogsCompute)o;
        return Objects.equals(this.aggregation, logsCompute.aggregation) && Objects.equals(this.interval, logsCompute.interval) && Objects.equals(this.metric, logsCompute.metric) && Objects.equals(this.type, logsCompute.type);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.interval, this.metric, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsCompute {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

