/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=LogsAggregationFunctionSerializer.class)
public class LogsAggregationFunction {
    public static final LogsAggregationFunction COUNT = new LogsAggregationFunction("count");
    public static final LogsAggregationFunction CARDINALITY = new LogsAggregationFunction("cardinality");
    public static final LogsAggregationFunction PERCENTILE_75 = new LogsAggregationFunction("pc75");
    public static final LogsAggregationFunction PERCENTILE_90 = new LogsAggregationFunction("pc90");
    public static final LogsAggregationFunction PERCENTILE_95 = new LogsAggregationFunction("pc95");
    public static final LogsAggregationFunction PERCENTILE_98 = new LogsAggregationFunction("pc98");
    public static final LogsAggregationFunction PERCENTILE_99 = new LogsAggregationFunction("pc99");
    public static final LogsAggregationFunction SUM = new LogsAggregationFunction("sum");
    public static final LogsAggregationFunction MIN = new LogsAggregationFunction("min");
    public static final LogsAggregationFunction MAX = new LogsAggregationFunction("max");
    public static final LogsAggregationFunction AVG = new LogsAggregationFunction("avg");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("count", "cardinality", "pc75", "pc90", "pc95", "pc98", "pc99", "sum", "min", "max", "avg"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    LogsAggregationFunction(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((LogsAggregationFunction)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static LogsAggregationFunction fromValue(String value) {
        return new LogsAggregationFunction(value);
    }

    public static class LogsAggregationFunctionSerializer
    extends StdSerializer<LogsAggregationFunction> {
        public LogsAggregationFunctionSerializer(Class<LogsAggregationFunction> t) {
            super(t);
        }

        public LogsAggregationFunctionSerializer() {
            this(null);
        }

        public void serialize(LogsAggregationFunction value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

