/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Number of netflow events indexed for each hour for a given organization.")
@JsonPropertyOrder(value={"hour", "indexed_event_count"})
public class UsageNetworkFlowsHour {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_INDEXED_EVENT_COUNT = "indexed_event_count";
    private Long indexedEventCount;

    public UsageNetworkFlowsHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageNetworkFlowsHour indexedEventCount(Long indexedEventCount) {
        this.indexedEventCount = indexedEventCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of netflow events indexed.")
    @JsonProperty(value="indexed_event_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIndexedEventCount() {
        return this.indexedEventCount;
    }

    public void setIndexedEventCount(Long indexedEventCount) {
        this.indexedEventCount = indexedEventCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageNetworkFlowsHour usageNetworkFlowsHour = (UsageNetworkFlowsHour)o;
        return Objects.equals(this.hour, usageNetworkFlowsHour.hour) && Objects.equals(this.indexedEventCount, usageNetworkFlowsHour.indexedEventCount);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.indexedEventCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageNetworkFlowsHour {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    indexedEventCount: ").append(this.toIndentedString(this.indexedEventCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

