/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsTriggerCITestLocation;
import com.datadog.api.v1.client.model.SyntheticsTriggerCITestRunResult;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object containing information about the tests triggered.")
@JsonPropertyOrder(value={"batch_id", "locations", "results", "triggered_check_ids"})
public class SyntheticsTriggerCITestsResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BATCH_ID = "batch_id";
    private String batchId;
    public static final String JSON_PROPERTY_LOCATIONS = "locations";
    private List<SyntheticsTriggerCITestLocation> locations = null;
    public static final String JSON_PROPERTY_RESULTS = "results";
    private List<SyntheticsTriggerCITestRunResult> results = null;
    public static final String JSON_PROPERTY_TRIGGERED_CHECK_IDS = "triggered_check_ids";
    private List<String> triggeredCheckIds = null;

    public SyntheticsTriggerCITestsResponse batchId(String batchId) {
        this.batchId = batchId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The public ID of the batch triggered.")
    @JsonProperty(value="batch_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public SyntheticsTriggerCITestsResponse locations(List<SyntheticsTriggerCITestLocation> locations) {
        this.locations = locations;
        for (SyntheticsTriggerCITestLocation item : locations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsTriggerCITestsResponse addLocationsItem(SyntheticsTriggerCITestLocation locationsItem) {
        if (this.locations == null) {
            this.locations = new ArrayList<SyntheticsTriggerCITestLocation>();
        }
        this.locations.add(locationsItem);
        this.unparsed |= locationsItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of Synthetics locations.")
    @JsonProperty(value="locations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsTriggerCITestLocation> getLocations() {
        return this.locations;
    }

    public void setLocations(List<SyntheticsTriggerCITestLocation> locations) {
        this.locations = locations;
    }

    public SyntheticsTriggerCITestsResponse results(List<SyntheticsTriggerCITestRunResult> results) {
        this.results = results;
        for (SyntheticsTriggerCITestRunResult item : results) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsTriggerCITestsResponse addResultsItem(SyntheticsTriggerCITestRunResult resultsItem) {
        if (this.results == null) {
            this.results = new ArrayList<SyntheticsTriggerCITestRunResult>();
        }
        this.results.add(resultsItem);
        this.unparsed |= resultsItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information about the tests runs.")
    @JsonProperty(value="results")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsTriggerCITestRunResult> getResults() {
        return this.results;
    }

    public void setResults(List<SyntheticsTriggerCITestRunResult> results) {
        this.results = results;
    }

    public SyntheticsTriggerCITestsResponse triggeredCheckIds(List<String> triggeredCheckIds) {
        this.triggeredCheckIds = triggeredCheckIds;
        return this;
    }

    public SyntheticsTriggerCITestsResponse addTriggeredCheckIdsItem(String triggeredCheckIdsItem) {
        if (this.triggeredCheckIds == null) {
            this.triggeredCheckIds = new ArrayList<String>();
        }
        this.triggeredCheckIds.add(triggeredCheckIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The public IDs of the Synthetics test triggered.")
    @JsonProperty(value="triggered_check_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTriggeredCheckIds() {
        return this.triggeredCheckIds;
    }

    public void setTriggeredCheckIds(List<String> triggeredCheckIds) {
        this.triggeredCheckIds = triggeredCheckIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsTriggerCITestsResponse syntheticsTriggerCITestsResponse = (SyntheticsTriggerCITestsResponse)o;
        return Objects.equals(this.batchId, syntheticsTriggerCITestsResponse.batchId) && Objects.equals(this.locations, syntheticsTriggerCITestsResponse.locations) && Objects.equals(this.results, syntheticsTriggerCITestsResponse.results) && Objects.equals(this.triggeredCheckIds, syntheticsTriggerCITestsResponse.triggeredCheckIds);
    }

    public int hashCode() {
        return Objects.hash(this.batchId, this.locations, this.results, this.triggeredCheckIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsTriggerCITestsResponse {\n");
        sb.append("    batchId: ").append(this.toIndentedString(this.batchId)).append("\n");
        sb.append("    locations: ").append(this.toIndentedString(this.locations)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    triggeredCheckIds: ").append(this.toIndentedString(this.triggeredCheckIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

