/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.ApiKey;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="List of API and application keys available for a given organization.")
@JsonPropertyOrder(value={"api_keys"})
public class ApiKeyListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_API_KEYS = "api_keys";
    private List<ApiKey> apiKeys = null;

    public ApiKeyListResponse apiKeys(List<ApiKey> apiKeys) {
        this.apiKeys = apiKeys;
        for (ApiKey item : apiKeys) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ApiKeyListResponse addApiKeysItem(ApiKey apiKeysItem) {
        if (this.apiKeys == null) {
            this.apiKeys = new ArrayList<ApiKey>();
        }
        this.apiKeys.add(apiKeysItem);
        this.unparsed |= apiKeysItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of API keys.")
    @JsonProperty(value="api_keys")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ApiKey> getApiKeys() {
        return this.apiKeys;
    }

    public void setApiKeys(List<ApiKey> apiKeys) {
        this.apiKeys = apiKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKeyListResponse apiKeyListResponse = (ApiKeyListResponse)o;
        return Objects.equals(this.apiKeys, apiKeyListResponse.apiKeys);
    }

    public int hashCode() {
        return Objects.hash(this.apiKeys);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiKeyListResponse {\n");
        sb.append("    apiKeys: ").append(this.toIndentedString(this.apiKeys)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

