/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.AWSNamespace;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The objects used to delete an AWS tag filter entry.")
@JsonPropertyOrder(value={"account_id", "namespace"})
public class AWSTagFilterDeleteRequest {
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_NAMESPACE = "namespace";
    private AWSNamespace namespace;

    public AWSTagFilterDeleteRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="FAKEAC0FAKEAC2FAKEAC", value="The unique identifier of your AWS account.")
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AWSTagFilterDeleteRequest namespace(AWSNamespace namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AWSNamespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(AWSNamespace namespace) {
        this.namespace = namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSTagFilterDeleteRequest awSTagFilterDeleteRequest = (AWSTagFilterDeleteRequest)o;
        return Objects.equals(this.accountId, awSTagFilterDeleteRequest.accountId) && Objects.equals((Object)this.namespace, (Object)awSTagFilterDeleteRequest.namespace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.namespace});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSTagFilterDeleteRequest {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString((Object)this.namespace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

