/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.MetricTagConfigurationCreateAttributes;
import com.datadog.api.v2.client.model.MetricTagConfigurationType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object for a single metric to be configure tags on.")
@JsonPropertyOrder(value={"attributes", "id", "type"})
public class MetricTagConfigurationCreateData {
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private MetricTagConfigurationCreateAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private MetricTagConfigurationType type = MetricTagConfigurationType.MANAGE_TAGS;

    public MetricTagConfigurationCreateData() {
    }

    @JsonCreator
    public MetricTagConfigurationCreateData(@JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") MetricTagConfigurationType type) {
        this.id = id;
        this.type = type;
    }

    public MetricTagConfigurationCreateData attributes(MetricTagConfigurationCreateAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetricTagConfigurationCreateAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(MetricTagConfigurationCreateAttributes attributes) {
        this.attributes = attributes;
    }

    public MetricTagConfigurationCreateData id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="test.metric.latency", required=true, value="The metric name for this resource.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MetricTagConfigurationCreateData type(MetricTagConfigurationType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MetricTagConfigurationType getType() {
        return this.type;
    }

    public void setType(MetricTagConfigurationType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricTagConfigurationCreateData metricTagConfigurationCreateData = (MetricTagConfigurationCreateData)o;
        return Objects.equals(this.attributes, metricTagConfigurationCreateData.attributes) && Objects.equals(this.id, metricTagConfigurationCreateData.id) && Objects.equals((Object)this.type, (Object)metricTagConfigurationCreateData.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributes, this.id, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricTagConfigurationCreateData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

