/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.FreeTextWidgetDefinitionType;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Free text is a widget that allows you to add headings to your screenboard. Commonly used to state the overall purpose of the dashboard. Only available on FREE layout dashboards.")
@JsonPropertyOrder(value={"color", "font_size", "text", "text_align", "type"})
public class FreeTextWidgetDefinition {
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color;
    public static final String JSON_PROPERTY_FONT_SIZE = "font_size";
    private String fontSize;
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_TEXT_ALIGN = "text_align";
    private WidgetTextAlign textAlign;
    public static final String JSON_PROPERTY_TYPE = "type";
    private FreeTextWidgetDefinitionType type = FreeTextWidgetDefinitionType.FREE_TEXT;

    public FreeTextWidgetDefinition() {
    }

    @JsonCreator
    public FreeTextWidgetDefinition(@JsonProperty(required=true, value="text") String text, @JsonProperty(required=true, value="type") FreeTextWidgetDefinitionType type) {
        this.text = text;
        this.type = type;
    }

    public FreeTextWidgetDefinition color(String color) {
        this.color = color;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Color of the text.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public FreeTextWidgetDefinition fontSize(String fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the text.")
    @JsonProperty(value="font_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public FreeTextWidgetDefinition text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="Text to display.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public FreeTextWidgetDefinition textAlign(WidgetTextAlign textAlign) {
        this.textAlign = textAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="text_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(WidgetTextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public FreeTextWidgetDefinition type(FreeTextWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FreeTextWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(FreeTextWidgetDefinitionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FreeTextWidgetDefinition freeTextWidgetDefinition = (FreeTextWidgetDefinition)o;
        return Objects.equals(this.color, freeTextWidgetDefinition.color) && Objects.equals(this.fontSize, freeTextWidgetDefinition.fontSize) && Objects.equals(this.text, freeTextWidgetDefinition.text) && Objects.equals((Object)this.textAlign, (Object)freeTextWidgetDefinition.textAlign) && Objects.equals((Object)this.type, (Object)freeTextWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.fontSize, this.text, this.textAlign, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FreeTextWidgetDefinition {\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    textAlign: ").append(this.toIndentedString((Object)this.textAlign)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

