/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsErrorCode;
import com.datadog.api.v1.client.model.SyntheticsSSLCertificate;
import com.datadog.api.v1.client.model.SyntheticsTestProcessStatus;
import com.datadog.api.v1.client.model.SyntheticsTiming;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object containing results for your Synthetic API test.")
@JsonPropertyOrder(value={"cert", "errorCode", "errorMessage", "eventType", "httpStatusCode", "requestHeaders", "responseBody", "responseHeaders", "responseSize", "timings"})
public class SyntheticsAPITestResultData {
    public static final String JSON_PROPERTY_CERT = "cert";
    private SyntheticsSSLCertificate cert;
    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    private SyntheticsErrorCode errorCode;
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
    private String errorMessage;
    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    private SyntheticsTestProcessStatus eventType;
    public static final String JSON_PROPERTY_HTTP_STATUS_CODE = "httpStatusCode";
    private Long httpStatusCode;
    public static final String JSON_PROPERTY_REQUEST_HEADERS = "requestHeaders";
    private Map<String, Object> requestHeaders = null;
    public static final String JSON_PROPERTY_RESPONSE_BODY = "responseBody";
    private String responseBody;
    public static final String JSON_PROPERTY_RESPONSE_HEADERS = "responseHeaders";
    private Map<String, Object> responseHeaders = null;
    public static final String JSON_PROPERTY_RESPONSE_SIZE = "responseSize";
    private Long responseSize;
    public static final String JSON_PROPERTY_TIMINGS = "timings";
    private SyntheticsTiming timings;

    public SyntheticsAPITestResultData cert(SyntheticsSSLCertificate cert) {
        this.cert = cert;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="cert")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsSSLCertificate getCert() {
        return this.cert;
    }

    public void setCert(SyntheticsSSLCertificate cert) {
        this.cert = cert;
    }

    public SyntheticsAPITestResultData errorCode(SyntheticsErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(SyntheticsErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public SyntheticsAPITestResultData errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The API test error message.")
    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public SyntheticsAPITestResultData eventType(SyntheticsTestProcessStatus eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestProcessStatus getEventType() {
        return this.eventType;
    }

    public void setEventType(SyntheticsTestProcessStatus eventType) {
        this.eventType = eventType;
    }

    public SyntheticsAPITestResultData httpStatusCode(Long httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The API test HTTP status code.")
    @JsonProperty(value="httpStatusCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(Long httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public SyntheticsAPITestResultData requestHeaders(Map<String, Object> requestHeaders) {
        this.requestHeaders = requestHeaders;
        return this;
    }

    public SyntheticsAPITestResultData putRequestHeadersItem(String key, Object requestHeadersItem) {
        if (this.requestHeaders == null) {
            this.requestHeaders = new HashMap<String, Object>();
        }
        this.requestHeaders.put(key, requestHeadersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Request header object used for the API test.")
    @JsonProperty(value="requestHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(Map<String, Object> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public SyntheticsAPITestResultData responseBody(String responseBody) {
        this.responseBody = responseBody;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Response body returned for the API test.")
    @JsonProperty(value="responseBody")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public SyntheticsAPITestResultData responseHeaders(Map<String, Object> responseHeaders) {
        this.responseHeaders = responseHeaders;
        return this;
    }

    public SyntheticsAPITestResultData putResponseHeadersItem(String key, Object responseHeadersItem) {
        if (this.responseHeaders == null) {
            this.responseHeaders = new HashMap<String, Object>();
        }
        this.responseHeaders.put(key, responseHeadersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Response headers returned for the API test.")
    @JsonProperty(value="responseHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, Object> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public SyntheticsAPITestResultData responseSize(Long responseSize) {
        this.responseSize = responseSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Global size in byte of the API test response.")
    @JsonProperty(value="responseSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getResponseSize() {
        return this.responseSize;
    }

    public void setResponseSize(Long responseSize) {
        this.responseSize = responseSize;
    }

    public SyntheticsAPITestResultData timings(SyntheticsTiming timings) {
        this.timings = timings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="timings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTiming getTimings() {
        return this.timings;
    }

    public void setTimings(SyntheticsTiming timings) {
        this.timings = timings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsAPITestResultData syntheticsAPITestResultData = (SyntheticsAPITestResultData)o;
        return Objects.equals(this.cert, syntheticsAPITestResultData.cert) && Objects.equals((Object)this.errorCode, (Object)syntheticsAPITestResultData.errorCode) && Objects.equals(this.errorMessage, syntheticsAPITestResultData.errorMessage) && Objects.equals((Object)this.eventType, (Object)syntheticsAPITestResultData.eventType) && Objects.equals(this.httpStatusCode, syntheticsAPITestResultData.httpStatusCode) && Objects.equals(this.requestHeaders, syntheticsAPITestResultData.requestHeaders) && Objects.equals(this.responseBody, syntheticsAPITestResultData.responseBody) && Objects.equals(this.responseHeaders, syntheticsAPITestResultData.responseHeaders) && Objects.equals(this.responseSize, syntheticsAPITestResultData.responseSize) && Objects.equals(this.timings, syntheticsAPITestResultData.timings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cert, this.errorCode, this.errorMessage, this.eventType, this.httpStatusCode, this.requestHeaders, this.responseBody, this.responseHeaders, this.responseSize, this.timings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsAPITestResultData {\n");
        sb.append("    cert: ").append(this.toIndentedString(this.cert)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString((Object)this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    httpStatusCode: ").append(this.toIndentedString(this.httpStatusCode)).append("\n");
        sb.append("    requestHeaders: ").append(this.toIndentedString(this.requestHeaders)).append("\n");
        sb.append("    responseBody: ").append(this.toIndentedString(this.responseBody)).append("\n");
        sb.append("    responseHeaders: ").append(this.toIndentedString(this.responseHeaders)).append("\n");
        sb.append("    responseSize: ").append(this.toIndentedString(this.responseSize)).append("\n");
        sb.append("    timings: ").append(this.toIndentedString(this.timings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

