/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A response list of all service level objective deleted.")
@JsonPropertyOrder(value={"data", "errors"})
public class SLODeleteResponse {
    public static final String JSON_PROPERTY_DATA = "data";
    private List<String> data = null;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private Map<String, String> errors = null;

    public SLODeleteResponse data(List<String> data) {
        this.data = data;
        return this;
    }

    public SLODeleteResponse addDataItem(String dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<String>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array containing the ID of the deleted service level objective object.")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getData() {
        return this.data;
    }

    public void setData(List<String> data) {
        this.data = data;
    }

    public SLODeleteResponse errors(Map<String, String> errors) {
        this.errors = errors;
        return this;
    }

    public SLODeleteResponse putErrorsItem(String key, String errorsItem) {
        if (this.errors == null) {
            this.errors = new HashMap<String, String>();
        }
        this.errors.put(key, errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An dictionary containing the ID of the SLO as key and a deletion error as value.")
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getErrors() {
        return this.errors;
    }

    public void setErrors(Map<String, String> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLODeleteResponse slODeleteResponse = (SLODeleteResponse)o;
        return Objects.equals(this.data, slODeleteResponse.data) && Objects.equals(this.errors, slODeleteResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLODeleteResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

