/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsPrivateLocationSecrets;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object containing information about the private location to create.")
@JsonPropertyOrder(value={"description", "id", "name", "secrets", "tags"})
public class SyntheticsPrivateLocation {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SECRETS = "secrets";
    private SyntheticsPrivateLocationSecrets secrets;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = new ArrayList<String>();

    public SyntheticsPrivateLocation description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Description of private location", required=true, value="Description of the private location.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the private location.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public SyntheticsPrivateLocation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="New private location", required=true, value="Name of the private location.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SyntheticsPrivateLocation secrets(SyntheticsPrivateLocationSecrets secrets) {
        this.secrets = secrets;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="secrets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsPrivateLocationSecrets getSecrets() {
        return this.secrets;
    }

    public void setSecrets(SyntheticsPrivateLocationSecrets secrets) {
        this.secrets = secrets;
    }

    public SyntheticsPrivateLocation tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SyntheticsPrivateLocation addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(example="[\"team:front\"]", required=true, value="Array of tags attached to the private location.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsPrivateLocation syntheticsPrivateLocation = (SyntheticsPrivateLocation)o;
        return Objects.equals(this.description, syntheticsPrivateLocation.description) && Objects.equals(this.id, syntheticsPrivateLocation.id) && Objects.equals(this.name, syntheticsPrivateLocation.name) && Objects.equals(this.secrets, syntheticsPrivateLocation.secrets) && Objects.equals(this.tags, syntheticsPrivateLocation.tags);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.id, this.name, this.secrets, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsPrivateLocation {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    secrets: ").append(this.toIndentedString(this.secrets)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

