/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsGlobalVariableParseTestOptionsType;
import com.datadog.api.v1.client.model.SyntheticsVariableParser;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Parser options to use for retrieving a Synthetics global variable from a Synthetics Test. Used in conjunction with `parse_test_public_id`.")
@JsonPropertyOrder(value={"field", "parser", "type"})
public class SyntheticsGlobalVariableParseTestOptions {
    public static final String JSON_PROPERTY_FIELD = "field";
    private String field;
    public static final String JSON_PROPERTY_PARSER = "parser";
    private SyntheticsVariableParser parser;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsGlobalVariableParseTestOptionsType type;

    public SyntheticsGlobalVariableParseTestOptions field(String field) {
        this.field = field;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="content-type", value="When type is `http_header`, name of the header to use to extract the value.")
    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public SyntheticsGlobalVariableParseTestOptions parser(SyntheticsVariableParser parser) {
        this.parser = parser;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="parser")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsVariableParser getParser() {
        return this.parser;
    }

    public void setParser(SyntheticsVariableParser parser) {
        this.parser = parser;
    }

    public SyntheticsGlobalVariableParseTestOptions type(SyntheticsGlobalVariableParseTestOptionsType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsGlobalVariableParseTestOptionsType getType() {
        return this.type;
    }

    public void setType(SyntheticsGlobalVariableParseTestOptionsType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsGlobalVariableParseTestOptions syntheticsGlobalVariableParseTestOptions = (SyntheticsGlobalVariableParseTestOptions)o;
        return Objects.equals(this.field, syntheticsGlobalVariableParseTestOptions.field) && Objects.equals(this.parser, syntheticsGlobalVariableParseTestOptions.parser) && Objects.equals((Object)this.type, (Object)syntheticsGlobalVariableParseTestOptions.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.parser, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsGlobalVariableParseTestOptions {\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    parser: ").append(this.toIndentedString(this.parser)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

