/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.UsageAnalyzedLogsResponse;
import com.datadog.api.v1.client.model.UsageAttributionResponse;
import com.datadog.api.v1.client.model.UsageAttributionSort;
import com.datadog.api.v1.client.model.UsageBillableSummaryResponse;
import com.datadog.api.v1.client.model.UsageComplianceResponse;
import com.datadog.api.v1.client.model.UsageCustomReportsResponse;
import com.datadog.api.v1.client.model.UsageFargateResponse;
import com.datadog.api.v1.client.model.UsageHostsResponse;
import com.datadog.api.v1.client.model.UsageIncidentManagementResponse;
import com.datadog.api.v1.client.model.UsageIndexedSpansResponse;
import com.datadog.api.v1.client.model.UsageIngestedSpansResponse;
import com.datadog.api.v1.client.model.UsageIoTResponse;
import com.datadog.api.v1.client.model.UsageLambdaResponse;
import com.datadog.api.v1.client.model.UsageLogsByIndexResponse;
import com.datadog.api.v1.client.model.UsageLogsResponse;
import com.datadog.api.v1.client.model.UsageNetworkFlowsResponse;
import com.datadog.api.v1.client.model.UsageNetworkHostsResponse;
import com.datadog.api.v1.client.model.UsageProfilingResponse;
import com.datadog.api.v1.client.model.UsageRumSessionsResponse;
import com.datadog.api.v1.client.model.UsageSNMPResponse;
import com.datadog.api.v1.client.model.UsageSort;
import com.datadog.api.v1.client.model.UsageSortDirection;
import com.datadog.api.v1.client.model.UsageSpecifiedCustomReportsResponse;
import com.datadog.api.v1.client.model.UsageSummaryResponse;
import com.datadog.api.v1.client.model.UsageSyntheticsAPIResponse;
import com.datadog.api.v1.client.model.UsageSyntheticsBrowserResponse;
import com.datadog.api.v1.client.model.UsageSyntheticsResponse;
import com.datadog.api.v1.client.model.UsageTimeseriesResponse;
import com.datadog.api.v1.client.model.UsageTopAvgMetricsResponse;
import com.datadog.api.v1.client.model.UsageTraceResponse;
import com.datadog.api.v1.client.model.UsageTracingWithoutLimitsResponse;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class UsageMeteringApi {
    private ApiClient apiClient;

    public UsageMeteringApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsageMeteringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UsageCustomReportsResponse getDailyCustomReports() throws ApiException {
        return this.getDailyCustomReportsWithHttpInfo(new GetDailyCustomReportsOptionalParameters()).getData();
    }

    public UsageCustomReportsResponse getDailyCustomReports(GetDailyCustomReportsOptionalParameters parameters) throws ApiException {
        return this.getDailyCustomReportsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<UsageCustomReportsResponse> getDailyCustomReportsWithHttpInfo(GetDailyCustomReportsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        UsageSortDirection sortDir = parameters.sortDir;
        UsageSort sort = parameters.sort;
        String localVarPath = "/api/v1/daily_custom_reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", (Object)sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarHeaderParams.put("DD-OPERATION-ID", "getDailyCustomReports");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageCustomReportsResponse> localVarReturnType = new GenericType<UsageCustomReportsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getDailyCustomReports", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageIncidentManagementResponse getIncidentManagement(OffsetDateTime startHr) throws ApiException {
        return this.getIncidentManagementWithHttpInfo(startHr, new GetIncidentManagementOptionalParameters()).getData();
    }

    public UsageIncidentManagementResponse getIncidentManagement(OffsetDateTime startHr, GetIncidentManagementOptionalParameters parameters) throws ApiException {
        return this.getIncidentManagementWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageIncidentManagementResponse> getIncidentManagementWithHttpInfo(OffsetDateTime startHr, GetIncidentManagementOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getIncidentManagement");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/incident-management";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getIncidentManagement");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageIncidentManagementResponse> localVarReturnType = new GenericType<UsageIncidentManagementResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getIncidentManagement", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageIngestedSpansResponse getIngestedSpans(OffsetDateTime startHr) throws ApiException {
        return this.getIngestedSpansWithHttpInfo(startHr, new GetIngestedSpansOptionalParameters()).getData();
    }

    public UsageIngestedSpansResponse getIngestedSpans(OffsetDateTime startHr, GetIngestedSpansOptionalParameters parameters) throws ApiException {
        return this.getIngestedSpansWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageIngestedSpansResponse> getIngestedSpansWithHttpInfo(OffsetDateTime startHr, GetIngestedSpansOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getIngestedSpans");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/ingested-spans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getIngestedSpans");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageIngestedSpansResponse> localVarReturnType = new GenericType<UsageIngestedSpansResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getIngestedSpans", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageCustomReportsResponse getMonthlyCustomReports() throws ApiException {
        return this.getMonthlyCustomReportsWithHttpInfo(new GetMonthlyCustomReportsOptionalParameters()).getData();
    }

    public UsageCustomReportsResponse getMonthlyCustomReports(GetMonthlyCustomReportsOptionalParameters parameters) throws ApiException {
        return this.getMonthlyCustomReportsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<UsageCustomReportsResponse> getMonthlyCustomReportsWithHttpInfo(GetMonthlyCustomReportsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        UsageSortDirection sortDir = parameters.sortDir;
        UsageSort sort = parameters.sort;
        String localVarPath = "/api/v1/monthly_custom_reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", (Object)sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarHeaderParams.put("DD-OPERATION-ID", "getMonthlyCustomReports");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageCustomReportsResponse> localVarReturnType = new GenericType<UsageCustomReportsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getMonthlyCustomReports", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSpecifiedCustomReportsResponse getSpecifiedDailyCustomReports(String reportId) throws ApiException {
        return this.getSpecifiedDailyCustomReportsWithHttpInfo(reportId).getData();
    }

    public ApiResponse<UsageSpecifiedCustomReportsResponse> getSpecifiedDailyCustomReportsWithHttpInfo(String reportId) throws ApiException {
        Object localVarPostBody = null;
        if (reportId == null) {
            throw new ApiException(400, "Missing the required parameter 'reportId' when calling getSpecifiedDailyCustomReports");
        }
        String localVarPath = "/api/v1/daily_custom_reports/{report_id}".replaceAll("\\{report_id\\}", this.apiClient.escapeString(reportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSpecifiedDailyCustomReports");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSpecifiedCustomReportsResponse> localVarReturnType = new GenericType<UsageSpecifiedCustomReportsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getSpecifiedDailyCustomReports", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSpecifiedCustomReportsResponse getSpecifiedMonthlyCustomReports(String reportId) throws ApiException {
        return this.getSpecifiedMonthlyCustomReportsWithHttpInfo(reportId).getData();
    }

    public ApiResponse<UsageSpecifiedCustomReportsResponse> getSpecifiedMonthlyCustomReportsWithHttpInfo(String reportId) throws ApiException {
        Object localVarPostBody = null;
        if (reportId == null) {
            throw new ApiException(400, "Missing the required parameter 'reportId' when calling getSpecifiedMonthlyCustomReports");
        }
        String localVarPath = "/api/v1/monthly_custom_reports/{report_id}".replaceAll("\\{report_id\\}", this.apiClient.escapeString(reportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSpecifiedMonthlyCustomReports");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSpecifiedCustomReportsResponse> localVarReturnType = new GenericType<UsageSpecifiedCustomReportsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getSpecifiedMonthlyCustomReports", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    @Deprecated
    public UsageTracingWithoutLimitsResponse getTracingWithoutLimits(OffsetDateTime startHr) throws ApiException {
        return this.getTracingWithoutLimitsWithHttpInfo(startHr, new GetTracingWithoutLimitsOptionalParameters()).getData();
    }

    @Deprecated
    public UsageTracingWithoutLimitsResponse getTracingWithoutLimits(OffsetDateTime startHr, GetTracingWithoutLimitsOptionalParameters parameters) throws ApiException {
        return this.getTracingWithoutLimitsWithHttpInfo(startHr, parameters).getData();
    }

    @Deprecated
    public ApiResponse<UsageTracingWithoutLimitsResponse> getTracingWithoutLimitsWithHttpInfo(OffsetDateTime startHr, GetTracingWithoutLimitsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getTracingWithoutLimits");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/tracing-without-limits";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getTracingWithoutLimits");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTracingWithoutLimitsResponse> localVarReturnType = new GenericType<UsageTracingWithoutLimitsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getTracingWithoutLimits", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageAnalyzedLogsResponse getUsageAnalyzedLogs(OffsetDateTime startHr) throws ApiException {
        return this.getUsageAnalyzedLogsWithHttpInfo(startHr, new GetUsageAnalyzedLogsOptionalParameters()).getData();
    }

    public UsageAnalyzedLogsResponse getUsageAnalyzedLogs(OffsetDateTime startHr, GetUsageAnalyzedLogsOptionalParameters parameters) throws ApiException {
        return this.getUsageAnalyzedLogsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageAnalyzedLogsResponse> getUsageAnalyzedLogsWithHttpInfo(OffsetDateTime startHr, GetUsageAnalyzedLogsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageAnalyzedLogs");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/analyzed_logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageAnalyzedLogs");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageAnalyzedLogsResponse> localVarReturnType = new GenericType<UsageAnalyzedLogsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageAnalyzedLogs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageAttributionResponse getUsageAttribution(OffsetDateTime startMonth, String fields) throws ApiException {
        return this.getUsageAttributionWithHttpInfo(startMonth, fields, new GetUsageAttributionOptionalParameters()).getData();
    }

    public UsageAttributionResponse getUsageAttribution(OffsetDateTime startMonth, String fields, GetUsageAttributionOptionalParameters parameters) throws ApiException {
        return this.getUsageAttributionWithHttpInfo(startMonth, fields, parameters).getData();
    }

    public ApiResponse<UsageAttributionResponse> getUsageAttributionWithHttpInfo(OffsetDateTime startMonth, String fields, GetUsageAttributionOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startMonth == null) {
            throw new ApiException(400, "Missing the required parameter 'startMonth' when calling getUsageAttribution");
        }
        if (fields == null) {
            throw new ApiException(400, "Missing the required parameter 'fields' when calling getUsageAttribution");
        }
        OffsetDateTime endMonth = parameters.endMonth;
        UsageSortDirection sortDirection = parameters.sortDirection;
        UsageAttributionSort sortName = parameters.sortName;
        String localVarPath = "/api/v1/usage/attribution";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_month", startMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fields", fields));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_month", endMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_direction", (Object)sortDirection));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_name", (Object)sortName));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageAttribution");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageAttributionResponse> localVarReturnType = new GenericType<UsageAttributionResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageAttribution", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageBillableSummaryResponse getUsageBillableSummary() throws ApiException {
        return this.getUsageBillableSummaryWithHttpInfo(new GetUsageBillableSummaryOptionalParameters()).getData();
    }

    public UsageBillableSummaryResponse getUsageBillableSummary(GetUsageBillableSummaryOptionalParameters parameters) throws ApiException {
        return this.getUsageBillableSummaryWithHttpInfo(parameters).getData();
    }

    public ApiResponse<UsageBillableSummaryResponse> getUsageBillableSummaryWithHttpInfo(GetUsageBillableSummaryOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        OffsetDateTime month = parameters.month;
        String localVarPath = "/api/v1/usage/billable-summary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "month", month));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageBillableSummary");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageBillableSummaryResponse> localVarReturnType = new GenericType<UsageBillableSummaryResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageBillableSummary", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageComplianceResponse getUsageComplianceMonitoring(OffsetDateTime startHr) throws ApiException {
        return this.getUsageComplianceMonitoringWithHttpInfo(startHr, new GetUsageComplianceMonitoringOptionalParameters()).getData();
    }

    public UsageComplianceResponse getUsageComplianceMonitoring(OffsetDateTime startHr, GetUsageComplianceMonitoringOptionalParameters parameters) throws ApiException {
        return this.getUsageComplianceMonitoringWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageComplianceResponse> getUsageComplianceMonitoringWithHttpInfo(OffsetDateTime startHr, GetUsageComplianceMonitoringOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageComplianceMonitoring");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/compliance-monitoring";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageComplianceMonitoring");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageComplianceResponse> localVarReturnType = new GenericType<UsageComplianceResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageComplianceMonitoring", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageFargateResponse getUsageFargate(OffsetDateTime startHr) throws ApiException {
        return this.getUsageFargateWithHttpInfo(startHr, new GetUsageFargateOptionalParameters()).getData();
    }

    public UsageFargateResponse getUsageFargate(OffsetDateTime startHr, GetUsageFargateOptionalParameters parameters) throws ApiException {
        return this.getUsageFargateWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageFargateResponse> getUsageFargateWithHttpInfo(OffsetDateTime startHr, GetUsageFargateOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageFargate");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/fargate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageFargate");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageFargateResponse> localVarReturnType = new GenericType<UsageFargateResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageFargate", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageHostsResponse getUsageHosts(OffsetDateTime startHr) throws ApiException {
        return this.getUsageHostsWithHttpInfo(startHr, new GetUsageHostsOptionalParameters()).getData();
    }

    public UsageHostsResponse getUsageHosts(OffsetDateTime startHr, GetUsageHostsOptionalParameters parameters) throws ApiException {
        return this.getUsageHostsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageHostsResponse> getUsageHostsWithHttpInfo(OffsetDateTime startHr, GetUsageHostsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageHosts");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageHosts");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageHostsResponse> localVarReturnType = new GenericType<UsageHostsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageHosts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageIndexedSpansResponse getUsageIndexedSpans(OffsetDateTime startHr) throws ApiException {
        return this.getUsageIndexedSpansWithHttpInfo(startHr, new GetUsageIndexedSpansOptionalParameters()).getData();
    }

    public UsageIndexedSpansResponse getUsageIndexedSpans(OffsetDateTime startHr, GetUsageIndexedSpansOptionalParameters parameters) throws ApiException {
        return this.getUsageIndexedSpansWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageIndexedSpansResponse> getUsageIndexedSpansWithHttpInfo(OffsetDateTime startHr, GetUsageIndexedSpansOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageIndexedSpans");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/indexed-spans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageIndexedSpans");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageIndexedSpansResponse> localVarReturnType = new GenericType<UsageIndexedSpansResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageIndexedSpans", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageIoTResponse getUsageInternetOfThings(OffsetDateTime startHr) throws ApiException {
        return this.getUsageInternetOfThingsWithHttpInfo(startHr, new GetUsageInternetOfThingsOptionalParameters()).getData();
    }

    public UsageIoTResponse getUsageInternetOfThings(OffsetDateTime startHr, GetUsageInternetOfThingsOptionalParameters parameters) throws ApiException {
        return this.getUsageInternetOfThingsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageIoTResponse> getUsageInternetOfThingsWithHttpInfo(OffsetDateTime startHr, GetUsageInternetOfThingsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageInternetOfThings");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/iot";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageInternetOfThings");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageIoTResponse> localVarReturnType = new GenericType<UsageIoTResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageInternetOfThings", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageLambdaResponse getUsageLambda(OffsetDateTime startHr) throws ApiException {
        return this.getUsageLambdaWithHttpInfo(startHr, new GetUsageLambdaOptionalParameters()).getData();
    }

    public UsageLambdaResponse getUsageLambda(OffsetDateTime startHr, GetUsageLambdaOptionalParameters parameters) throws ApiException {
        return this.getUsageLambdaWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageLambdaResponse> getUsageLambdaWithHttpInfo(OffsetDateTime startHr, GetUsageLambdaOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLambda");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/aws_lambda";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLambda");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLambdaResponse> localVarReturnType = new GenericType<UsageLambdaResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLambda", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageLogsResponse getUsageLogs(OffsetDateTime startHr) throws ApiException {
        return this.getUsageLogsWithHttpInfo(startHr, new GetUsageLogsOptionalParameters()).getData();
    }

    public UsageLogsResponse getUsageLogs(OffsetDateTime startHr, GetUsageLogsOptionalParameters parameters) throws ApiException {
        return this.getUsageLogsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageLogsResponse> getUsageLogsWithHttpInfo(OffsetDateTime startHr, GetUsageLogsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLogs");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLogs");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLogsResponse> localVarReturnType = new GenericType<UsageLogsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLogs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageLogsByIndexResponse getUsageLogsByIndex(OffsetDateTime startHr) throws ApiException {
        return this.getUsageLogsByIndexWithHttpInfo(startHr, new GetUsageLogsByIndexOptionalParameters()).getData();
    }

    public UsageLogsByIndexResponse getUsageLogsByIndex(OffsetDateTime startHr, GetUsageLogsByIndexOptionalParameters parameters) throws ApiException {
        return this.getUsageLogsByIndexWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageLogsByIndexResponse> getUsageLogsByIndexWithHttpInfo(OffsetDateTime startHr, GetUsageLogsByIndexOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLogsByIndex");
        }
        OffsetDateTime endHr = parameters.endHr;
        List indexName = parameters.indexName;
        String localVarPath = "/api/v1/usage/logs_by_index";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "index_name", indexName));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLogsByIndex");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLogsByIndexResponse> localVarReturnType = new GenericType<UsageLogsByIndexResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLogsByIndex", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageNetworkFlowsResponse getUsageNetworkFlows(OffsetDateTime startHr) throws ApiException {
        return this.getUsageNetworkFlowsWithHttpInfo(startHr, new GetUsageNetworkFlowsOptionalParameters()).getData();
    }

    public UsageNetworkFlowsResponse getUsageNetworkFlows(OffsetDateTime startHr, GetUsageNetworkFlowsOptionalParameters parameters) throws ApiException {
        return this.getUsageNetworkFlowsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageNetworkFlowsResponse> getUsageNetworkFlowsWithHttpInfo(OffsetDateTime startHr, GetUsageNetworkFlowsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageNetworkFlows");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/network_flows";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageNetworkFlows");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageNetworkFlowsResponse> localVarReturnType = new GenericType<UsageNetworkFlowsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageNetworkFlows", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageNetworkHostsResponse getUsageNetworkHosts(OffsetDateTime startHr) throws ApiException {
        return this.getUsageNetworkHostsWithHttpInfo(startHr, new GetUsageNetworkHostsOptionalParameters()).getData();
    }

    public UsageNetworkHostsResponse getUsageNetworkHosts(OffsetDateTime startHr, GetUsageNetworkHostsOptionalParameters parameters) throws ApiException {
        return this.getUsageNetworkHostsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageNetworkHostsResponse> getUsageNetworkHostsWithHttpInfo(OffsetDateTime startHr, GetUsageNetworkHostsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageNetworkHosts");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/network_hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageNetworkHosts");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageNetworkHostsResponse> localVarReturnType = new GenericType<UsageNetworkHostsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageNetworkHosts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageProfilingResponse getUsageProfiling(OffsetDateTime startHr) throws ApiException {
        return this.getUsageProfilingWithHttpInfo(startHr, new GetUsageProfilingOptionalParameters()).getData();
    }

    public UsageProfilingResponse getUsageProfiling(OffsetDateTime startHr, GetUsageProfilingOptionalParameters parameters) throws ApiException {
        return this.getUsageProfilingWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageProfilingResponse> getUsageProfilingWithHttpInfo(OffsetDateTime startHr, GetUsageProfilingOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageProfiling");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/profiling";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageProfiling");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageProfilingResponse> localVarReturnType = new GenericType<UsageProfilingResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageProfiling", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageRumSessionsResponse getUsageRumSessions(OffsetDateTime startHr) throws ApiException {
        return this.getUsageRumSessionsWithHttpInfo(startHr, new GetUsageRumSessionsOptionalParameters()).getData();
    }

    public UsageRumSessionsResponse getUsageRumSessions(OffsetDateTime startHr, GetUsageRumSessionsOptionalParameters parameters) throws ApiException {
        return this.getUsageRumSessionsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageRumSessionsResponse> getUsageRumSessionsWithHttpInfo(OffsetDateTime startHr, GetUsageRumSessionsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageRumSessions");
        }
        OffsetDateTime endHr = parameters.endHr;
        String type = parameters.type;
        String localVarPath = "/api/v1/usage/rum_sessions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", type));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageRumSessions");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageRumSessionsResponse> localVarReturnType = new GenericType<UsageRumSessionsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageRumSessions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSNMPResponse getUsageSNMP(OffsetDateTime startHr) throws ApiException {
        return this.getUsageSNMPWithHttpInfo(startHr, new GetUsageSNMPOptionalParameters()).getData();
    }

    public UsageSNMPResponse getUsageSNMP(OffsetDateTime startHr, GetUsageSNMPOptionalParameters parameters) throws ApiException {
        return this.getUsageSNMPWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageSNMPResponse> getUsageSNMPWithHttpInfo(OffsetDateTime startHr, GetUsageSNMPOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSNMP");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/snmp";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSNMP");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSNMPResponse> localVarReturnType = new GenericType<UsageSNMPResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSNMP", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSummaryResponse getUsageSummary(OffsetDateTime startMonth) throws ApiException {
        return this.getUsageSummaryWithHttpInfo(startMonth, new GetUsageSummaryOptionalParameters()).getData();
    }

    public UsageSummaryResponse getUsageSummary(OffsetDateTime startMonth, GetUsageSummaryOptionalParameters parameters) throws ApiException {
        return this.getUsageSummaryWithHttpInfo(startMonth, parameters).getData();
    }

    public ApiResponse<UsageSummaryResponse> getUsageSummaryWithHttpInfo(OffsetDateTime startMonth, GetUsageSummaryOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startMonth == null) {
            throw new ApiException(400, "Missing the required parameter 'startMonth' when calling getUsageSummary");
        }
        OffsetDateTime endMonth = parameters.endMonth;
        Boolean includeOrgDetails = parameters.includeOrgDetails;
        String localVarPath = "/api/v1/usage/summary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_month", startMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_month", endMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_org_details", includeOrgDetails));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSummary");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSummaryResponse> localVarReturnType = new GenericType<UsageSummaryResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSummary", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    @Deprecated
    public UsageSyntheticsResponse getUsageSynthetics(OffsetDateTime startHr) throws ApiException {
        return this.getUsageSyntheticsWithHttpInfo(startHr, new GetUsageSyntheticsOptionalParameters()).getData();
    }

    @Deprecated
    public UsageSyntheticsResponse getUsageSynthetics(OffsetDateTime startHr, GetUsageSyntheticsOptionalParameters parameters) throws ApiException {
        return this.getUsageSyntheticsWithHttpInfo(startHr, parameters).getData();
    }

    @Deprecated
    public ApiResponse<UsageSyntheticsResponse> getUsageSyntheticsWithHttpInfo(OffsetDateTime startHr, GetUsageSyntheticsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSynthetics");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/synthetics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSynthetics");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSyntheticsResponse> localVarReturnType = new GenericType<UsageSyntheticsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSynthetics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSyntheticsAPIResponse getUsageSyntheticsAPI(OffsetDateTime startHr) throws ApiException {
        return this.getUsageSyntheticsAPIWithHttpInfo(startHr, new GetUsageSyntheticsAPIOptionalParameters()).getData();
    }

    public UsageSyntheticsAPIResponse getUsageSyntheticsAPI(OffsetDateTime startHr, GetUsageSyntheticsAPIOptionalParameters parameters) throws ApiException {
        return this.getUsageSyntheticsAPIWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageSyntheticsAPIResponse> getUsageSyntheticsAPIWithHttpInfo(OffsetDateTime startHr, GetUsageSyntheticsAPIOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSyntheticsAPI");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/synthetics_api";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSyntheticsAPI");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSyntheticsAPIResponse> localVarReturnType = new GenericType<UsageSyntheticsAPIResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSyntheticsAPI", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSyntheticsBrowserResponse getUsageSyntheticsBrowser(OffsetDateTime startHr) throws ApiException {
        return this.getUsageSyntheticsBrowserWithHttpInfo(startHr, new GetUsageSyntheticsBrowserOptionalParameters()).getData();
    }

    public UsageSyntheticsBrowserResponse getUsageSyntheticsBrowser(OffsetDateTime startHr, GetUsageSyntheticsBrowserOptionalParameters parameters) throws ApiException {
        return this.getUsageSyntheticsBrowserWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageSyntheticsBrowserResponse> getUsageSyntheticsBrowserWithHttpInfo(OffsetDateTime startHr, GetUsageSyntheticsBrowserOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSyntheticsBrowser");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/synthetics_browser";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSyntheticsBrowser");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSyntheticsBrowserResponse> localVarReturnType = new GenericType<UsageSyntheticsBrowserResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSyntheticsBrowser", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageTimeseriesResponse getUsageTimeseries(OffsetDateTime startHr) throws ApiException {
        return this.getUsageTimeseriesWithHttpInfo(startHr, new GetUsageTimeseriesOptionalParameters()).getData();
    }

    public UsageTimeseriesResponse getUsageTimeseries(OffsetDateTime startHr, GetUsageTimeseriesOptionalParameters parameters) throws ApiException {
        return this.getUsageTimeseriesWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageTimeseriesResponse> getUsageTimeseriesWithHttpInfo(OffsetDateTime startHr, GetUsageTimeseriesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageTimeseries");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/timeseries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageTimeseries");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTimeseriesResponse> localVarReturnType = new GenericType<UsageTimeseriesResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageTimeseries", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageTopAvgMetricsResponse getUsageTopAvgMetrics() throws ApiException {
        return this.getUsageTopAvgMetricsWithHttpInfo(new GetUsageTopAvgMetricsOptionalParameters()).getData();
    }

    public UsageTopAvgMetricsResponse getUsageTopAvgMetrics(GetUsageTopAvgMetricsOptionalParameters parameters) throws ApiException {
        return this.getUsageTopAvgMetricsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<UsageTopAvgMetricsResponse> getUsageTopAvgMetricsWithHttpInfo(GetUsageTopAvgMetricsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        OffsetDateTime month = parameters.month;
        OffsetDateTime day = parameters.day;
        List names = parameters.names;
        Integer limit = parameters.limit;
        String localVarPath = "/api/v1/usage/top_avg_metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "month", month));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "day", day));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "names", names));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageTopAvgMetrics");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTopAvgMetricsResponse> localVarReturnType = new GenericType<UsageTopAvgMetricsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageTopAvgMetrics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    @Deprecated
    public UsageTraceResponse getUsageTrace(OffsetDateTime startHr) throws ApiException {
        return this.getUsageTraceWithHttpInfo(startHr, new GetUsageTraceOptionalParameters()).getData();
    }

    @Deprecated
    public UsageTraceResponse getUsageTrace(OffsetDateTime startHr, GetUsageTraceOptionalParameters parameters) throws ApiException {
        return this.getUsageTraceWithHttpInfo(startHr, parameters).getData();
    }

    @Deprecated
    public ApiResponse<UsageTraceResponse> getUsageTraceWithHttpInfo(OffsetDateTime startHr, GetUsageTraceOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageTrace");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/traces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageTrace");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTraceResponse> localVarReturnType = new GenericType<UsageTraceResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageTrace", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class GetUsageTraceOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageTraceOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageTopAvgMetricsOptionalParameters {
        private OffsetDateTime month;
        private OffsetDateTime day;
        private List<String> names;
        private Integer limit;

        public GetUsageTopAvgMetricsOptionalParameters month(OffsetDateTime month) {
            this.month = month;
            return this;
        }

        public GetUsageTopAvgMetricsOptionalParameters day(OffsetDateTime day) {
            this.day = day;
            return this;
        }

        public GetUsageTopAvgMetricsOptionalParameters names(List<String> names) {
            this.names = names;
            return this;
        }

        public GetUsageTopAvgMetricsOptionalParameters limit(Integer limit) {
            this.limit = limit;
            return this;
        }
    }

    public static class GetUsageTimeseriesOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageTimeseriesOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageSyntheticsBrowserOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageSyntheticsBrowserOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageSyntheticsAPIOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageSyntheticsAPIOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageSyntheticsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageSyntheticsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageSummaryOptionalParameters {
        private OffsetDateTime endMonth;
        private Boolean includeOrgDetails;

        public GetUsageSummaryOptionalParameters endMonth(OffsetDateTime endMonth) {
            this.endMonth = endMonth;
            return this;
        }

        public GetUsageSummaryOptionalParameters includeOrgDetails(Boolean includeOrgDetails) {
            this.includeOrgDetails = includeOrgDetails;
            return this;
        }
    }

    public static class GetUsageSNMPOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageSNMPOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageRumSessionsOptionalParameters {
        private OffsetDateTime endHr;
        private String type;

        public GetUsageRumSessionsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public GetUsageRumSessionsOptionalParameters type(String type) {
            this.type = type;
            return this;
        }
    }

    public static class GetUsageProfilingOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageProfilingOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageNetworkHostsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageNetworkHostsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageNetworkFlowsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageNetworkFlowsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageLogsByIndexOptionalParameters {
        private OffsetDateTime endHr;
        private List<String> indexName;

        public GetUsageLogsByIndexOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public GetUsageLogsByIndexOptionalParameters indexName(List<String> indexName) {
            this.indexName = indexName;
            return this;
        }
    }

    public static class GetUsageLogsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageLogsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageLambdaOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageLambdaOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageInternetOfThingsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageInternetOfThingsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageIndexedSpansOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageIndexedSpansOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageHostsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageHostsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageFargateOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageFargateOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageComplianceMonitoringOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageComplianceMonitoringOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageBillableSummaryOptionalParameters {
        private OffsetDateTime month;

        public GetUsageBillableSummaryOptionalParameters month(OffsetDateTime month) {
            this.month = month;
            return this;
        }
    }

    public static class GetUsageAttributionOptionalParameters {
        private OffsetDateTime endMonth;
        private UsageSortDirection sortDirection;
        private UsageAttributionSort sortName;

        public GetUsageAttributionOptionalParameters endMonth(OffsetDateTime endMonth) {
            this.endMonth = endMonth;
            return this;
        }

        public GetUsageAttributionOptionalParameters sortDirection(UsageSortDirection sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        public GetUsageAttributionOptionalParameters sortName(UsageAttributionSort sortName) {
            this.sortName = sortName;
            return this;
        }
    }

    public static class GetUsageAnalyzedLogsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageAnalyzedLogsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetTracingWithoutLimitsOptionalParameters {
        private OffsetDateTime endHr;

        public GetTracingWithoutLimitsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetMonthlyCustomReportsOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private UsageSortDirection sortDir;
        private UsageSort sort;

        public GetMonthlyCustomReportsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetMonthlyCustomReportsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public GetMonthlyCustomReportsOptionalParameters sortDir(UsageSortDirection sortDir) {
            this.sortDir = sortDir;
            return this;
        }

        public GetMonthlyCustomReportsOptionalParameters sort(UsageSort sort) {
            this.sort = sort;
            return this;
        }
    }

    public static class GetIngestedSpansOptionalParameters {
        private OffsetDateTime endHr;

        public GetIngestedSpansOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetIncidentManagementOptionalParameters {
        private OffsetDateTime endHr;

        public GetIncidentManagementOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetDailyCustomReportsOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private UsageSortDirection sortDir;
        private UsageSort sort;

        public GetDailyCustomReportsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetDailyCustomReportsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public GetDailyCustomReportsOptionalParameters sortDir(UsageSortDirection sortDir) {
            this.sortDir = sortDir;
            return this;
        }

        public GetDailyCustomReportsOptionalParameters sort(UsageSort sort) {
            this.sort = sort;
            return this;
        }
    }
}

