/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.LogsMetricCreateRequest;
import com.datadog.api.v2.client.model.LogsMetricResponse;
import com.datadog.api.v2.client.model.LogsMetricUpdateRequest;
import com.datadog.api.v2.client.model.LogsMetricsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class LogsMetricsApi {
    private ApiClient apiClient;

    public LogsMetricsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogsMetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<LogsMetricResponse> createLogsMetricWithHttpInfo(LogsMetricCreateRequest body) throws ApiException {
        LogsMetricCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createLogsMetric");
        }
        String localVarPath = "/api/v2/logs/config/metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createLogsMetric");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsMetricResponse> localVarReturnType = new GenericType<LogsMetricResponse>(){};
        return this.apiClient.invokeAPI("LogsMetricsApi.createLogsMetric", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateLogsMetricRequest createLogsMetric() throws ApiException {
        return new APIcreateLogsMetricRequest();
    }

    private ApiResponse<Void> deleteLogsMetricWithHttpInfo(String metricId) throws ApiException {
        Object localVarPostBody = null;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling deleteLogsMetric");
        }
        String localVarPath = "/api/v2/logs/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteLogsMetric");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("LogsMetricsApi.deleteLogsMetric", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIdeleteLogsMetricRequest deleteLogsMetric(String metricId) throws ApiException {
        return new APIdeleteLogsMetricRequest(metricId);
    }

    private ApiResponse<LogsMetricResponse> getLogsMetricWithHttpInfo(String metricId) throws ApiException {
        Object localVarPostBody = null;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling getLogsMetric");
        }
        String localVarPath = "/api/v2/logs/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getLogsMetric");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsMetricResponse> localVarReturnType = new GenericType<LogsMetricResponse>(){};
        return this.apiClient.invokeAPI("LogsMetricsApi.getLogsMetric", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetLogsMetricRequest getLogsMetric(String metricId) throws ApiException {
        return new APIgetLogsMetricRequest(metricId);
    }

    private ApiResponse<LogsMetricsResponse> listLogsMetricsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listLogsMetrics");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsMetricsResponse> localVarReturnType = new GenericType<LogsMetricsResponse>(){};
        return this.apiClient.invokeAPI("LogsMetricsApi.listLogsMetrics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistLogsMetricsRequest listLogsMetrics() throws ApiException {
        return new APIlistLogsMetricsRequest();
    }

    private ApiResponse<LogsMetricResponse> updateLogsMetricWithHttpInfo(String metricId, LogsMetricUpdateRequest body) throws ApiException {
        LogsMetricUpdateRequest localVarPostBody = body;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling updateLogsMetric");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsMetric");
        }
        String localVarPath = "/api/v2/logs/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateLogsMetric");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsMetricResponse> localVarReturnType = new GenericType<LogsMetricResponse>(){};
        return this.apiClient.invokeAPI("LogsMetricsApi.updateLogsMetric", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateLogsMetricRequest updateLogsMetric(String metricId) throws ApiException {
        return new APIupdateLogsMetricRequest(metricId);
    }

    public class APIupdateLogsMetricRequest {
        private String metricId;
        private LogsMetricUpdateRequest body;

        private APIupdateLogsMetricRequest(String metricId) {
            this.metricId = metricId;
        }

        public APIupdateLogsMetricRequest body(LogsMetricUpdateRequest body) {
            this.body = body;
            return this;
        }

        public LogsMetricResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsMetricResponse> executeWithHttpInfo() throws ApiException {
            return LogsMetricsApi.this.updateLogsMetricWithHttpInfo(this.metricId, this.body);
        }
    }

    public class APIlistLogsMetricsRequest {
        private APIlistLogsMetricsRequest() {
        }

        public LogsMetricsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsMetricsResponse> executeWithHttpInfo() throws ApiException {
            return LogsMetricsApi.this.listLogsMetricsWithHttpInfo();
        }
    }

    public class APIgetLogsMetricRequest {
        private String metricId;

        private APIgetLogsMetricRequest(String metricId) {
            this.metricId = metricId;
        }

        public LogsMetricResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsMetricResponse> executeWithHttpInfo() throws ApiException {
            return LogsMetricsApi.this.getLogsMetricWithHttpInfo(this.metricId);
        }
    }

    public class APIdeleteLogsMetricRequest {
        private String metricId;

        private APIdeleteLogsMetricRequest(String metricId) {
            this.metricId = metricId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return LogsMetricsApi.this.deleteLogsMetricWithHttpInfo(this.metricId);
        }
    }

    public class APIcreateLogsMetricRequest {
        private LogsMetricCreateRequest body;

        private APIcreateLogsMetricRequest() {
        }

        public APIcreateLogsMetricRequest body(LogsMetricCreateRequest body) {
            this.body = body;
            return this;
        }

        public LogsMetricResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsMetricResponse> executeWithHttpInfo() throws ApiException {
            return LogsMetricsApi.this.createLogsMetricWithHttpInfo(this.body);
        }
    }
}

