/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.IncidentCreateRequest;
import com.datadog.api.v2.client.model.IncidentRelatedObject;
import com.datadog.api.v2.client.model.IncidentResponse;
import com.datadog.api.v2.client.model.IncidentUpdateRequest;
import com.datadog.api.v2.client.model.IncidentsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class IncidentsApi {
    private ApiClient apiClient;

    public IncidentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IncidentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<IncidentResponse> createIncidentWithHttpInfo(IncidentCreateRequest body) throws ApiException {
        IncidentCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncident");
        }
        String localVarPath = "/api/v2/incidents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createIncident");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentResponse> localVarReturnType = new GenericType<IncidentResponse>(){};
        return this.apiClient.invokeAPI("IncidentsApi.createIncident", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateIncidentRequest createIncident() throws ApiException {
        String operationId = "createIncident";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIcreateIncidentRequest();
    }

    private ApiResponse<Void> deleteIncidentWithHttpInfo(String incidentId) throws ApiException {
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling deleteIncident");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteIncident");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("IncidentsApi.deleteIncident", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIdeleteIncidentRequest deleteIncident(String incidentId) throws ApiException {
        String operationId = "deleteIncident";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIdeleteIncidentRequest(incidentId);
    }

    private ApiResponse<IncidentResponse> getIncidentWithHttpInfo(String incidentId, List<IncidentRelatedObject> include) throws ApiException {
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling getIncident");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "getIncident");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentResponse> localVarReturnType = new GenericType<IncidentResponse>(){};
        return this.apiClient.invokeAPI("IncidentsApi.getIncident", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetIncidentRequest getIncident(String incidentId) throws ApiException {
        String operationId = "getIncident";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIgetIncidentRequest(incidentId);
    }

    private ApiResponse<IncidentsResponse> listIncidentsWithHttpInfo(List<IncidentRelatedObject> include, Long pageSize, Long pageOffset) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/incidents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarHeaderParams.put("DD-OPERATION-ID", "listIncidents");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentsResponse> localVarReturnType = new GenericType<IncidentsResponse>(){};
        return this.apiClient.invokeAPI("IncidentsApi.listIncidents", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistIncidentsRequest listIncidents() throws ApiException {
        String operationId = "listIncidents";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIlistIncidentsRequest();
    }

    private ApiResponse<IncidentResponse> updateIncidentWithHttpInfo(String incidentId, IncidentUpdateRequest body) throws ApiException {
        IncidentUpdateRequest localVarPostBody = body;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncident");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncident");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateIncident");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentResponse> localVarReturnType = new GenericType<IncidentResponse>(){};
        return this.apiClient.invokeAPI("IncidentsApi.updateIncident", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateIncidentRequest updateIncident(String incidentId) throws ApiException {
        String operationId = "updateIncident";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIupdateIncidentRequest(incidentId);
    }

    public class APIupdateIncidentRequest {
        private String incidentId;
        private IncidentUpdateRequest body;

        private APIupdateIncidentRequest(String incidentId) {
            this.incidentId = incidentId;
        }

        public APIupdateIncidentRequest body(IncidentUpdateRequest body) {
            this.body = body;
            return this;
        }

        public IncidentResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IncidentResponse> executeWithHttpInfo() throws ApiException {
            return IncidentsApi.this.updateIncidentWithHttpInfo(this.incidentId, this.body);
        }
    }

    public class APIlistIncidentsRequest {
        private List<IncidentRelatedObject> include;
        private Long pageSize;
        private Long pageOffset;

        private APIlistIncidentsRequest() {
        }

        public APIlistIncidentsRequest include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }

        public APIlistIncidentsRequest pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public APIlistIncidentsRequest pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public IncidentsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IncidentsResponse> executeWithHttpInfo() throws ApiException {
            return IncidentsApi.this.listIncidentsWithHttpInfo(this.include, this.pageSize, this.pageOffset);
        }
    }

    public class APIgetIncidentRequest {
        private String incidentId;
        private List<IncidentRelatedObject> include;

        private APIgetIncidentRequest(String incidentId) {
            this.incidentId = incidentId;
        }

        public APIgetIncidentRequest include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }

        public IncidentResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IncidentResponse> executeWithHttpInfo() throws ApiException {
            return IncidentsApi.this.getIncidentWithHttpInfo(this.incidentId, this.include);
        }
    }

    public class APIdeleteIncidentRequest {
        private String incidentId;

        private APIdeleteIncidentRequest(String incidentId) {
            this.incidentId = incidentId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return IncidentsApi.this.deleteIncidentWithHttpInfo(this.incidentId);
        }
    }

    public class APIcreateIncidentRequest {
        private IncidentCreateRequest body;

        private APIcreateIncidentRequest() {
        }

        public APIcreateIncidentRequest body(IncidentCreateRequest body) {
            this.body = body;
            return this;
        }

        public IncidentResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IncidentResponse> executeWithHttpInfo() throws ApiException {
            return IncidentsApi.this.createIncidentWithHttpInfo(this.body);
        }
    }
}

