/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogQueryDefinition;
import com.datadog.api.v1.client.model.ProcessQueryDefinition;
import com.datadog.api.v1.client.model.WidgetConditionalFormat;
import com.datadog.api.v1.client.model.WidgetRequestStyle;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Updated top list widget.")
@JsonPropertyOrder(value={"apm_query", "conditional_formats", "event_query", "log_query", "network_query", "process_query", "q", "rum_query", "security_query", "style"})
public class ToplistWidgetRequest {
    public static final String JSON_PROPERTY_APM_QUERY = "apm_query";
    private LogQueryDefinition apmQuery;
    public static final String JSON_PROPERTY_CONDITIONAL_FORMATS = "conditional_formats";
    private List<WidgetConditionalFormat> conditionalFormats = null;
    public static final String JSON_PROPERTY_EVENT_QUERY = "event_query";
    private LogQueryDefinition eventQuery;
    public static final String JSON_PROPERTY_LOG_QUERY = "log_query";
    private LogQueryDefinition logQuery;
    public static final String JSON_PROPERTY_NETWORK_QUERY = "network_query";
    private LogQueryDefinition networkQuery;
    public static final String JSON_PROPERTY_PROCESS_QUERY = "process_query";
    private ProcessQueryDefinition processQuery;
    public static final String JSON_PROPERTY_Q = "q";
    private String q;
    public static final String JSON_PROPERTY_RUM_QUERY = "rum_query";
    private LogQueryDefinition rumQuery;
    public static final String JSON_PROPERTY_SECURITY_QUERY = "security_query";
    private LogQueryDefinition securityQuery;
    public static final String JSON_PROPERTY_STYLE = "style";
    private WidgetRequestStyle style;

    public ToplistWidgetRequest apmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="apm_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getApmQuery() {
        return this.apmQuery;
    }

    public void setApmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
    }

    public ToplistWidgetRequest conditionalFormats(List<WidgetConditionalFormat> conditionalFormats) {
        this.conditionalFormats = conditionalFormats;
        return this;
    }

    public ToplistWidgetRequest addConditionalFormatsItem(WidgetConditionalFormat conditionalFormatsItem) {
        if (this.conditionalFormats == null) {
            this.conditionalFormats = new ArrayList<WidgetConditionalFormat>();
        }
        this.conditionalFormats.add(conditionalFormatsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"comparator\":\">=\",\"palette\":\"blue\",\"value\":1.0}]", value="List of conditional formats.")
    @JsonProperty(value="conditional_formats")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetConditionalFormat> getConditionalFormats() {
        return this.conditionalFormats;
    }

    public void setConditionalFormats(List<WidgetConditionalFormat> conditionalFormats) {
        this.conditionalFormats = conditionalFormats;
    }

    public ToplistWidgetRequest eventQuery(LogQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="event_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getEventQuery() {
        return this.eventQuery;
    }

    public void setEventQuery(LogQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
    }

    public ToplistWidgetRequest logQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="log_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getLogQuery() {
        return this.logQuery;
    }

    public void setLogQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
    }

    public ToplistWidgetRequest networkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="network_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getNetworkQuery() {
        return this.networkQuery;
    }

    public void setNetworkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
    }

    public ToplistWidgetRequest processQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="process_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessQueryDefinition getProcessQuery() {
        return this.processQuery;
    }

    public void setProcessQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
    }

    public ToplistWidgetRequest q(String q) {
        this.q = q;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Widget query.")
    @JsonProperty(value="q")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public ToplistWidgetRequest rumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="rum_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getRumQuery() {
        return this.rumQuery;
    }

    public void setRumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
    }

    public ToplistWidgetRequest securityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="security_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getSecurityQuery() {
        return this.securityQuery;
    }

    public void setSecurityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
    }

    public ToplistWidgetRequest style(WidgetRequestStyle style) {
        this.style = style;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetRequestStyle getStyle() {
        return this.style;
    }

    public void setStyle(WidgetRequestStyle style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToplistWidgetRequest toplistWidgetRequest = (ToplistWidgetRequest)o;
        return Objects.equals(this.apmQuery, toplistWidgetRequest.apmQuery) && Objects.equals(this.conditionalFormats, toplistWidgetRequest.conditionalFormats) && Objects.equals(this.eventQuery, toplistWidgetRequest.eventQuery) && Objects.equals(this.logQuery, toplistWidgetRequest.logQuery) && Objects.equals(this.networkQuery, toplistWidgetRequest.networkQuery) && Objects.equals(this.processQuery, toplistWidgetRequest.processQuery) && Objects.equals(this.q, toplistWidgetRequest.q) && Objects.equals(this.rumQuery, toplistWidgetRequest.rumQuery) && Objects.equals(this.securityQuery, toplistWidgetRequest.securityQuery) && Objects.equals(this.style, toplistWidgetRequest.style);
    }

    public int hashCode() {
        return Objects.hash(this.apmQuery, this.conditionalFormats, this.eventQuery, this.logQuery, this.networkQuery, this.processQuery, this.q, this.rumQuery, this.securityQuery, this.style);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ToplistWidgetRequest {\n");
        sb.append("    apmQuery: ").append(this.toIndentedString(this.apmQuery)).append("\n");
        sb.append("    conditionalFormats: ").append(this.toIndentedString(this.conditionalFormats)).append("\n");
        sb.append("    eventQuery: ").append(this.toIndentedString(this.eventQuery)).append("\n");
        sb.append("    logQuery: ").append(this.toIndentedString(this.logQuery)).append("\n");
        sb.append("    networkQuery: ").append(this.toIndentedString(this.networkQuery)).append("\n");
        sb.append("    processQuery: ").append(this.toIndentedString(this.processQuery)).append("\n");
        sb.append("    q: ").append(this.toIndentedString(this.q)).append("\n");
        sb.append("    rumQuery: ").append(this.toIndentedString(this.rumQuery)).append("\n");
        sb.append("    securityQuery: ").append(this.toIndentedString(this.securityQuery)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

