/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.AzureAccount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class AzureIntegrationApi {
    private ApiClient apiClient;

    public AzureIntegrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AzureIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<Object> createAzureIntegrationWithHttpInfo(AzureAccount body) throws ApiException {
        AzureAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAzureIntegration");
        }
        String localVarPath = "/api/v1/integration/azure";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createAzureIntegration");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("AzureIntegrationApi.createAzureIntegration", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateAzureIntegrationRequest createAzureIntegration() throws ApiException {
        return new APIcreateAzureIntegrationRequest();
    }

    private ApiResponse<Object> deleteAzureIntegrationWithHttpInfo(AzureAccount body) throws ApiException {
        AzureAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteAzureIntegration");
        }
        String localVarPath = "/api/v1/integration/azure";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteAzureIntegration");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("AzureIntegrationApi.deleteAzureIntegration", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIdeleteAzureIntegrationRequest deleteAzureIntegration() throws ApiException {
        return new APIdeleteAzureIntegrationRequest();
    }

    private ApiResponse<List<AzureAccount>> listAzureIntegrationWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/integration/azure";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listAzureIntegration");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<List<AzureAccount>> localVarReturnType = new GenericType<List<AzureAccount>>(){};
        return this.apiClient.invokeAPI("AzureIntegrationApi.listAzureIntegration", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistAzureIntegrationRequest listAzureIntegration() throws ApiException {
        return new APIlistAzureIntegrationRequest();
    }

    private ApiResponse<Object> updateAzureHostFiltersWithHttpInfo(AzureAccount body) throws ApiException {
        AzureAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAzureHostFilters");
        }
        String localVarPath = "/api/v1/integration/azure/host_filters";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateAzureHostFilters");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("AzureIntegrationApi.updateAzureHostFilters", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateAzureHostFiltersRequest updateAzureHostFilters() throws ApiException {
        return new APIupdateAzureHostFiltersRequest();
    }

    private ApiResponse<Object> updateAzureIntegrationWithHttpInfo(AzureAccount body) throws ApiException {
        AzureAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAzureIntegration");
        }
        String localVarPath = "/api/v1/integration/azure";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateAzureIntegration");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("AzureIntegrationApi.updateAzureIntegration", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateAzureIntegrationRequest updateAzureIntegration() throws ApiException {
        return new APIupdateAzureIntegrationRequest();
    }

    public class APIupdateAzureIntegrationRequest {
        private AzureAccount body;

        private APIupdateAzureIntegrationRequest() {
        }

        public APIupdateAzureIntegrationRequest body(AzureAccount body) {
            this.body = body;
            return this;
        }

        public Object execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return AzureIntegrationApi.this.updateAzureIntegrationWithHttpInfo(this.body);
        }
    }

    public class APIupdateAzureHostFiltersRequest {
        private AzureAccount body;

        private APIupdateAzureHostFiltersRequest() {
        }

        public APIupdateAzureHostFiltersRequest body(AzureAccount body) {
            this.body = body;
            return this;
        }

        public Object execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return AzureIntegrationApi.this.updateAzureHostFiltersWithHttpInfo(this.body);
        }
    }

    public class APIlistAzureIntegrationRequest {
        private APIlistAzureIntegrationRequest() {
        }

        public List<AzureAccount> execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<List<AzureAccount>> executeWithHttpInfo() throws ApiException {
            return AzureIntegrationApi.this.listAzureIntegrationWithHttpInfo();
        }
    }

    public class APIdeleteAzureIntegrationRequest {
        private AzureAccount body;

        private APIdeleteAzureIntegrationRequest() {
        }

        public APIdeleteAzureIntegrationRequest body(AzureAccount body) {
            this.body = body;
            return this;
        }

        public Object execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return AzureIntegrationApi.this.deleteAzureIntegrationWithHttpInfo(this.body);
        }
    }

    public class APIcreateAzureIntegrationRequest {
        private AzureAccount body;

        private APIcreateAzureIntegrationRequest() {
        }

        public APIcreateAzureIntegrationRequest body(AzureAccount body) {
            this.body = body;
            return this;
        }

        public Object execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return AzureIntegrationApi.this.createAzureIntegrationWithHttpInfo(this.body);
        }
    }
}

