/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.JSON;
import com.datadog.api.v2.client.model.AbstractOpenApiSchema;
import com.datadog.api.v2.client.model.Organization;
import com.datadog.api.v2.client.model.Permission;
import com.datadog.api.v2.client.model.Role;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

@JsonDeserialize(using=UserResponseIncludedItemDeserializer.class)
@JsonSerialize(using=UserResponseIncludedItemSerializer.class)
public class UserResponseIncludedItem
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(UserResponseIncludedItem.class.getName());
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public UserResponseIncludedItem() {
        super("oneOf", Boolean.FALSE);
    }

    public UserResponseIncludedItem(Organization o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public UserResponseIncludedItem(Permission o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public UserResponseIncludedItem(Role o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(Organization.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(Permission.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(Role.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be Organization, Permission, Role");
    }

    static {
        schemas.put("Organization", (GenericType)new GenericType<Organization>(){});
        schemas.put("Permission", (GenericType)new GenericType<Permission>(){});
        schemas.put("Role", (GenericType)new GenericType<Role>(){});
        JSON.registerDescendants(UserResponseIncludedItem.class, Collections.unmodifiableMap(schemas));
    }

    public static class UserResponseIncludedItemDeserializer
    extends StdDeserializer<UserResponseIncludedItem> {
        public UserResponseIncludedItemDeserializer() {
            this(UserResponseIncludedItem.class);
        }

        public UserResponseIncludedItemDeserializer(Class<?> vc) {
            super(vc);
        }

        public UserResponseIncludedItem deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            int match = 0;
            try {
                deserialized = tree.traverse(jp.getCodec()).readValueAs(Organization.class);
                ++match;
                log.log(Level.FINER, "Input data matches schema 'Organization'");
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'Organization'", e);
            }
            try {
                deserialized = tree.traverse(jp.getCodec()).readValueAs(Permission.class);
                ++match;
                log.log(Level.FINER, "Input data matches schema 'Permission'");
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'Permission'", e);
            }
            try {
                deserialized = tree.traverse(jp.getCodec()).readValueAs(Role.class);
                ++match;
                log.log(Level.FINER, "Input data matches schema 'Role'");
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'Role'", e);
            }
            if (match == 1) {
                UserResponseIncludedItem ret = new UserResponseIncludedItem();
                ret.setActualInstance(deserialized);
                return ret;
            }
            throw new IOException(String.format("Failed deserialization for UserResponseIncludedItem: %d classes match result, expected 1", match));
        }

        public UserResponseIncludedItem getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "UserResponseIncludedItem cannot be null");
        }
    }

    public static class UserResponseIncludedItemSerializer
    extends StdSerializer<UserResponseIncludedItem> {
        public UserResponseIncludedItemSerializer(Class<UserResponseIncludedItem> t) {
            super(t);
        }

        public UserResponseIncludedItemSerializer() {
            this(null);
        }

        public void serialize(UserResponseIncludedItem value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

