/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.DashboardListItem;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Dashboards within a list.")
@JsonPropertyOrder(value={"dashboards", "total"})
public class DashboardListItems {
    public static final String JSON_PROPERTY_DASHBOARDS = "dashboards";
    private List<DashboardListItem> dashboards = new ArrayList<DashboardListItem>();
    public static final String JSON_PROPERTY_TOTAL = "total";
    private Long total;

    public DashboardListItems dashboards(List<DashboardListItem> dashboards) {
        this.dashboards = dashboards;
        return this;
    }

    public DashboardListItems addDashboardsItem(DashboardListItem dashboardsItem) {
        this.dashboards.add(dashboardsItem);
        return this;
    }

    @ApiModelProperty(example="[]", required=true, value="List of dashboards in the dashboard list.")
    @JsonProperty(value="dashboards")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<DashboardListItem> getDashboards() {
        return this.dashboards;
    }

    public void setDashboards(List<DashboardListItem> dashboards) {
        this.dashboards = dashboards;
    }

    @Nullable
    @ApiModelProperty(value="Number of dashboards in the dashboard list.")
    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotal() {
        return this.total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardListItems dashboardListItems = (DashboardListItems)o;
        return Objects.equals(this.dashboards, dashboardListItems.dashboards) && Objects.equals(this.total, dashboardListItems.total);
    }

    public int hashCode() {
        return Objects.hash(this.dashboards, this.total);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardListItems {\n");
        sb.append("    dashboards: ").append(this.toIndentedString(this.dashboards)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

