/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.HTTPMethod;
import com.datadog.api.v1.client.model.SyntheticsTestRequestBasicAuth;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object describing the Synthetic test request.")
@JsonPropertyOrder(value={"basicAuth", "body", "headers", "host", "method", "port", "query", "timeout", "url"})
public class SyntheticsTestRequest {
    public static final String JSON_PROPERTY_BASIC_AUTH = "basicAuth";
    private SyntheticsTestRequestBasicAuth basicAuth;
    public static final String JSON_PROPERTY_BODY = "body";
    private String body;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    private Map<String, String> headers = null;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_METHOD = "method";
    private HTTPMethod method;
    public static final String JSON_PROPERTY_PORT = "port";
    private Long port;
    public static final String JSON_PROPERTY_QUERY = "query";
    private Object query;
    public static final String JSON_PROPERTY_TIMEOUT = "timeout";
    private Double timeout;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public SyntheticsTestRequest basicAuth(SyntheticsTestRequestBasicAuth basicAuth) {
        this.basicAuth = basicAuth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="basicAuth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestRequestBasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    public void setBasicAuth(SyntheticsTestRequestBasicAuth basicAuth) {
        this.basicAuth = basicAuth;
    }

    public SyntheticsTestRequest body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Body to include in the test.")
    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public SyntheticsTestRequest headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public SyntheticsTestRequest putHeadersItem(String key, String headersItem) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, headersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Headers to include when performing the test.")
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public SyntheticsTestRequest host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Host name to perform the test with.")
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public SyntheticsTestRequest method(HTTPMethod method) {
        this.method = method;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HTTPMethod getMethod() {
        return this.method;
    }

    public void setMethod(HTTPMethod method) {
        this.method = method;
    }

    public SyntheticsTestRequest port(Long port) {
        this.port = port;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Port to use when performing the test.")
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPort() {
        return this.port;
    }

    public void setPort(Long port) {
        this.port = port;
    }

    public SyntheticsTestRequest query(Object query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Query to use for the test.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getQuery() {
        return this.query;
    }

    public void setQuery(Object query) {
        this.query = query;
    }

    public SyntheticsTestRequest timeout(Double timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timeout in millisecond for the test.")
    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Double timeout) {
        this.timeout = timeout;
    }

    public SyntheticsTestRequest url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to perform the test with.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsTestRequest syntheticsTestRequest = (SyntheticsTestRequest)o;
        return Objects.equals(this.basicAuth, syntheticsTestRequest.basicAuth) && Objects.equals(this.body, syntheticsTestRequest.body) && Objects.equals(this.headers, syntheticsTestRequest.headers) && Objects.equals(this.host, syntheticsTestRequest.host) && Objects.equals((Object)this.method, (Object)syntheticsTestRequest.method) && Objects.equals(this.port, syntheticsTestRequest.port) && Objects.equals(this.query, syntheticsTestRequest.query) && Objects.equals(this.timeout, syntheticsTestRequest.timeout) && Objects.equals(this.url, syntheticsTestRequest.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.basicAuth, this.body, this.headers, this.host, this.method, this.port, this.query, this.timeout, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsTestRequest {\n");
        sb.append("    basicAuth: ").append(this.toIndentedString(this.basicAuth)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

