/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SLOHistoryMetricsSeries;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A `metric` based SLO history response.")
@JsonPropertyOrder(value={"denominator", "interval", "message", "numerator", "query", "res_type", "resp_version", "times"})
public class SLOHistoryMetrics {
    public static final String JSON_PROPERTY_DENOMINATOR = "denominator";
    private SLOHistoryMetricsSeries denominator;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private Long interval;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_NUMERATOR = "numerator";
    private SLOHistoryMetricsSeries numerator;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_RES_TYPE = "res_type";
    private String resType;
    public static final String JSON_PROPERTY_RESP_VERSION = "resp_version";
    private Long respVersion;
    public static final String JSON_PROPERTY_TIMES = "times";
    private List<Double> times = new ArrayList<Double>();

    public SLOHistoryMetrics denominator(SLOHistoryMetricsSeries denominator) {
        this.denominator = denominator;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="denominator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SLOHistoryMetricsSeries getDenominator() {
        return this.denominator;
    }

    public void setDenominator(SLOHistoryMetricsSeries denominator) {
        this.denominator = denominator;
    }

    public SLOHistoryMetrics interval(Long interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="The aggregated query interval for the series data. It's implicit based on the query time window.")
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public SLOHistoryMetrics message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional message if there are specific query issues/warnings.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SLOHistoryMetrics numerator(SLOHistoryMetricsSeries numerator) {
        this.numerator = numerator;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="numerator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SLOHistoryMetricsSeries getNumerator() {
        return this.numerator;
    }

    public void setNumerator(SLOHistoryMetricsSeries numerator) {
        this.numerator = numerator;
    }

    public SLOHistoryMetrics query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(required=true, value="The combined numerator and denominator query CSV.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public SLOHistoryMetrics resType(String resType) {
        this.resType = resType;
        return this;
    }

    @ApiModelProperty(required=true, value="The series result type. This mimics `batch_query` response type.")
    @JsonProperty(value="res_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getResType() {
        return this.resType;
    }

    public void setResType(String resType) {
        this.resType = resType;
    }

    public SLOHistoryMetrics respVersion(Long respVersion) {
        this.respVersion = respVersion;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="The series response version type. This mimics `batch_query` response type.")
    @JsonProperty(value="resp_version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getRespVersion() {
        return this.respVersion;
    }

    public void setRespVersion(Long respVersion) {
        this.respVersion = respVersion;
    }

    public SLOHistoryMetrics times(List<Double> times) {
        this.times = times;
        return this;
    }

    public SLOHistoryMetrics addTimesItem(Double timesItem) {
        this.times.add(timesItem);
        return this;
    }

    @ApiModelProperty(example="[]", required=true, value="An array of query timestamps in EPOCH milliseconds")
    @JsonProperty(value="times")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Double> getTimes() {
        return this.times;
    }

    public void setTimes(List<Double> times) {
        this.times = times;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOHistoryMetrics slOHistoryMetrics = (SLOHistoryMetrics)o;
        return Objects.equals(this.denominator, slOHistoryMetrics.denominator) && Objects.equals(this.interval, slOHistoryMetrics.interval) && Objects.equals(this.message, slOHistoryMetrics.message) && Objects.equals(this.numerator, slOHistoryMetrics.numerator) && Objects.equals(this.query, slOHistoryMetrics.query) && Objects.equals(this.resType, slOHistoryMetrics.resType) && Objects.equals(this.respVersion, slOHistoryMetrics.respVersion) && Objects.equals(this.times, slOHistoryMetrics.times);
    }

    public int hashCode() {
        return Objects.hash(this.denominator, this.interval, this.message, this.numerator, this.query, this.resType, this.respVersion, this.times);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOHistoryMetrics {\n");
        sb.append("    denominator: ").append(this.toIndentedString(this.denominator)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    numerator: ").append(this.toIndentedString(this.numerator)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    resType: ").append(this.toIndentedString(this.resType)).append("\n");
        sb.append("    respVersion: ").append(this.toIndentedString(this.respVersion)).append("\n");
        sb.append("    times: ").append(this.toIndentedString(this.times)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

