/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsUserAgentParserType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The User-Agent parser takes a User-Agent attribute and extracts the OS, browser, device, and other user data. It recognizes major bots like the Google Bot, Yahoo Slurp, and Bing.")
@JsonPropertyOrder(value={"is_enabled", "is_encoded", "name", "sources", "target", "type"})
public class LogsUserAgentParser {
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_IS_ENCODED = "is_encoded";
    private Boolean isEncoded = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = new ArrayList<String>();
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target = "http.useragent_details";
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsUserAgentParserType type = LogsUserAgentParserType.USER_AGENT_PARSER;

    public LogsUserAgentParser isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the processor is enabled.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsUserAgentParser isEncoded(Boolean isEncoded) {
        this.isEncoded = isEncoded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Define if the source attribute is URL encoded or not.")
    @JsonProperty(value="is_encoded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEncoded() {
        return this.isEncoded;
    }

    public void setIsEncoded(Boolean isEncoded) {
        this.isEncoded = isEncoded;
    }

    public LogsUserAgentParser name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the processor.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsUserAgentParser sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public LogsUserAgentParser addSourcesItem(String sourcesItem) {
        this.sources.add(sourcesItem);
        return this;
    }

    @ApiModelProperty(example="[\"http.useragent\"]", required=true, value="Array of source attributes.")
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public LogsUserAgentParser target(String target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="http.useragent_details", required=true, value="Name of the parent attribute that contains all the extracted details from the `sources`.")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public LogsUserAgentParser type(LogsUserAgentParserType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsUserAgentParserType getType() {
        return this.type;
    }

    public void setType(LogsUserAgentParserType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsUserAgentParser logsUserAgentParser = (LogsUserAgentParser)o;
        return Objects.equals(this.isEnabled, logsUserAgentParser.isEnabled) && Objects.equals(this.isEncoded, logsUserAgentParser.isEncoded) && Objects.equals(this.name, logsUserAgentParser.name) && Objects.equals(this.sources, logsUserAgentParser.sources) && Objects.equals(this.target, logsUserAgentParser.target) && Objects.equals((Object)this.type, (Object)logsUserAgentParser.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isEnabled, this.isEncoded, this.name, this.sources, this.target, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsUserAgentParser {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    isEncoded: ").append(this.toIndentedString(this.isEncoded)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

