/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.CheckCanDeleteMonitorResponse;
import com.datadog.api.v1.client.model.DeletedMonitor;
import com.datadog.api.v1.client.model.Monitor;
import com.datadog.api.v1.client.model.MonitorUpdateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class MonitorsApi {
    private ApiClient apiClient;

    public MonitorsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MonitorsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<CheckCanDeleteMonitorResponse> checkCanDeleteMonitorWithHttpInfo(List<Long> monitorIds) throws ApiException {
        Object localVarPostBody = null;
        if (monitorIds == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorIds' when calling checkCanDeleteMonitor");
        }
        String localVarPath = "/api/v1/monitor/can_delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "monitor_ids", monitorIds));
        localVarHeaderParams.put("DD-OPERATION-ID", "checkCanDeleteMonitor");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<CheckCanDeleteMonitorResponse> localVarReturnType = new GenericType<CheckCanDeleteMonitorResponse>(){};
        return this.apiClient.invokeAPI("MonitorsApi.checkCanDeleteMonitor", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIcheckCanDeleteMonitorRequest checkCanDeleteMonitor() throws ApiException {
        return new APIcheckCanDeleteMonitorRequest();
    }

    private ApiResponse<Monitor> createMonitorWithHttpInfo(Monitor body) throws ApiException {
        Monitor localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createMonitor");
        }
        String localVarPath = "/api/v1/monitor";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createMonitor");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Monitor> localVarReturnType = new GenericType<Monitor>(){};
        return this.apiClient.invokeAPI("MonitorsApi.createMonitor", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIcreateMonitorRequest createMonitor() throws ApiException {
        return new APIcreateMonitorRequest();
    }

    private ApiResponse<DeletedMonitor> deleteMonitorWithHttpInfo(Long monitorId, String force) throws ApiException {
        Object localVarPostBody = null;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling deleteMonitor");
        }
        String localVarPath = "/api/v1/monitor/{monitor_id}".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "force", force));
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteMonitor");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DeletedMonitor> localVarReturnType = new GenericType<DeletedMonitor>(){};
        return this.apiClient.invokeAPI("MonitorsApi.deleteMonitor", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIdeleteMonitorRequest deleteMonitor(Long monitorId) throws ApiException {
        return new APIdeleteMonitorRequest(monitorId);
    }

    private ApiResponse<Monitor> getMonitorWithHttpInfo(Long monitorId, String groupStates) throws ApiException {
        Object localVarPostBody = null;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling getMonitor");
        }
        String localVarPath = "/api/v1/monitor/{monitor_id}".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_states", groupStates));
        localVarHeaderParams.put("DD-OPERATION-ID", "getMonitor");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Monitor> localVarReturnType = new GenericType<Monitor>(){};
        return this.apiClient.invokeAPI("MonitorsApi.getMonitor", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetMonitorRequest getMonitor(Long monitorId) throws ApiException {
        return new APIgetMonitorRequest(monitorId);
    }

    private ApiResponse<List<Monitor>> listMonitorsWithHttpInfo(String groupStates, String name, String tags, String monitorTags, Boolean withDowntimes, Long idOffset, Long page, Integer pageSize) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/monitor";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_states", groupStates));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "monitor_tags", monitorTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with_downtimes", withDowntimes));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id_offset", idOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarHeaderParams.put("DD-OPERATION-ID", "listMonitors");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<List<Monitor>> localVarReturnType = new GenericType<List<Monitor>>(){};
        return this.apiClient.invokeAPI("MonitorsApi.listMonitors", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistMonitorsRequest listMonitors() throws ApiException {
        return new APIlistMonitorsRequest();
    }

    private ApiResponse<Monitor> updateMonitorWithHttpInfo(Long monitorId, MonitorUpdateRequest body) throws ApiException {
        MonitorUpdateRequest localVarPostBody = body;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling updateMonitor");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateMonitor");
        }
        String localVarPath = "/api/v1/monitor/{monitor_id}".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateMonitor");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Monitor> localVarReturnType = new GenericType<Monitor>(){};
        return this.apiClient.invokeAPI("MonitorsApi.updateMonitor", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIupdateMonitorRequest updateMonitor(Long monitorId) throws ApiException {
        return new APIupdateMonitorRequest(monitorId);
    }

    private ApiResponse<Monitor> validateMonitorWithHttpInfo(Monitor body) throws ApiException {
        Monitor localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling validateMonitor");
        }
        String localVarPath = "/api/v1/monitor/validate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "validateMonitor");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Monitor> localVarReturnType = new GenericType<Monitor>(){};
        return this.apiClient.invokeAPI("MonitorsApi.validateMonitor", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIvalidateMonitorRequest validateMonitor() throws ApiException {
        return new APIvalidateMonitorRequest();
    }

    public class APIvalidateMonitorRequest {
        private Monitor body;

        private APIvalidateMonitorRequest() {
        }

        public APIvalidateMonitorRequest body(Monitor body) {
            this.body = body;
            return this;
        }

        public Monitor execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Monitor> executeWithHttpInfo() throws ApiException {
            return MonitorsApi.this.validateMonitorWithHttpInfo(this.body);
        }
    }

    public class APIupdateMonitorRequest {
        private Long monitorId;
        private MonitorUpdateRequest body;

        private APIupdateMonitorRequest(Long monitorId) {
            this.monitorId = monitorId;
        }

        public APIupdateMonitorRequest body(MonitorUpdateRequest body) {
            this.body = body;
            return this;
        }

        public Monitor execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Monitor> executeWithHttpInfo() throws ApiException {
            return MonitorsApi.this.updateMonitorWithHttpInfo(this.monitorId, this.body);
        }
    }

    public class APIlistMonitorsRequest {
        private String groupStates;
        private String name;
        private String tags;
        private String monitorTags;
        private Boolean withDowntimes;
        private Long idOffset;
        private Long page;
        private Integer pageSize;

        private APIlistMonitorsRequest() {
        }

        public APIlistMonitorsRequest groupStates(String groupStates) {
            this.groupStates = groupStates;
            return this;
        }

        public APIlistMonitorsRequest name(String name) {
            this.name = name;
            return this;
        }

        public APIlistMonitorsRequest tags(String tags) {
            this.tags = tags;
            return this;
        }

        public APIlistMonitorsRequest monitorTags(String monitorTags) {
            this.monitorTags = monitorTags;
            return this;
        }

        public APIlistMonitorsRequest withDowntimes(Boolean withDowntimes) {
            this.withDowntimes = withDowntimes;
            return this;
        }

        public APIlistMonitorsRequest idOffset(Long idOffset) {
            this.idOffset = idOffset;
            return this;
        }

        public APIlistMonitorsRequest page(Long page) {
            this.page = page;
            return this;
        }

        public APIlistMonitorsRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public List<Monitor> execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<List<Monitor>> executeWithHttpInfo() throws ApiException {
            return MonitorsApi.this.listMonitorsWithHttpInfo(this.groupStates, this.name, this.tags, this.monitorTags, this.withDowntimes, this.idOffset, this.page, this.pageSize);
        }
    }

    public class APIgetMonitorRequest {
        private Long monitorId;
        private String groupStates;

        private APIgetMonitorRequest(Long monitorId) {
            this.monitorId = monitorId;
        }

        public APIgetMonitorRequest groupStates(String groupStates) {
            this.groupStates = groupStates;
            return this;
        }

        public Monitor execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Monitor> executeWithHttpInfo() throws ApiException {
            return MonitorsApi.this.getMonitorWithHttpInfo(this.monitorId, this.groupStates);
        }
    }

    public class APIdeleteMonitorRequest {
        private Long monitorId;
        private String force;

        private APIdeleteMonitorRequest(Long monitorId) {
            this.monitorId = monitorId;
        }

        public APIdeleteMonitorRequest force(String force) {
            this.force = force;
            return this;
        }

        public DeletedMonitor execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<DeletedMonitor> executeWithHttpInfo() throws ApiException {
            return MonitorsApi.this.deleteMonitorWithHttpInfo(this.monitorId, this.force);
        }
    }

    public class APIcreateMonitorRequest {
        private Monitor body;

        private APIcreateMonitorRequest() {
        }

        public APIcreateMonitorRequest body(Monitor body) {
            this.body = body;
            return this;
        }

        public Monitor execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Monitor> executeWithHttpInfo() throws ApiException {
            return MonitorsApi.this.createMonitorWithHttpInfo(this.body);
        }
    }

    public class APIcheckCanDeleteMonitorRequest {
        private List<Long> monitorIds;

        private APIcheckCanDeleteMonitorRequest() {
        }

        public APIcheckCanDeleteMonitorRequest monitorIds(List<Long> monitorIds) {
            this.monitorIds = monitorIds;
            return this;
        }

        public CheckCanDeleteMonitorResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<CheckCanDeleteMonitorResponse> executeWithHttpInfo() throws ApiException {
            return MonitorsApi.this.checkCanDeleteMonitorWithHttpInfo(this.monitorIds);
        }
    }
}

