/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.SecurityMonitoringRuleSeverity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Case when signal is generated.")
@JsonPropertyOrder(value={"condition", "name", "notifications", "status"})
public class SecurityMonitoringRuleCase {
    public static final String JSON_PROPERTY_CONDITION = "condition";
    private String condition;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NOTIFICATIONS = "notifications";
    private List<String> notifications = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private SecurityMonitoringRuleSeverity status;

    public SecurityMonitoringRuleCase condition(String condition) {
        this.condition = condition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A rule case contains logical operations (>, >=, &&, ||) to determine if a signal should be generated based on the event counts in the previously defined queries.")
    @JsonProperty(value="condition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public SecurityMonitoringRuleCase name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the case.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityMonitoringRuleCase notifications(List<String> notifications) {
        this.notifications = notifications;
        return this;
    }

    public SecurityMonitoringRuleCase addNotificationsItem(String notificationsItem) {
        if (this.notifications == null) {
            this.notifications = new ArrayList<String>();
        }
        this.notifications.add(notificationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Notification targets for each rule case")
    @JsonProperty(value="notifications")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<String> notifications) {
        this.notifications = notifications;
    }

    public SecurityMonitoringRuleCase status(SecurityMonitoringRuleSeverity status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleSeverity getStatus() {
        return this.status;
    }

    public void setStatus(SecurityMonitoringRuleSeverity status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringRuleCase securityMonitoringRuleCase = (SecurityMonitoringRuleCase)o;
        return Objects.equals(this.condition, securityMonitoringRuleCase.condition) && Objects.equals(this.name, securityMonitoringRuleCase.name) && Objects.equals(this.notifications, securityMonitoringRuleCase.notifications) && Objects.equals((Object)this.status, (Object)securityMonitoringRuleCase.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.condition, this.name, this.notifications, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringRuleCase {\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    notifications: ").append(this.toIndentedString(this.notifications)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

