/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.PagerDutyService;
import com.datadog.api.v1.client.model.PagerDutyServiceKey;
import com.datadog.api.v1.client.model.PagerDutyServiceName;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class PagerDutyIntegrationApi {
    private ApiClient apiClient;

    public PagerDutyIntegrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PagerDutyIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<PagerDutyServiceName> createPagerDutyIntegrationServiceWithHttpInfo(PagerDutyService body) throws ApiException {
        PagerDutyService localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createPagerDutyIntegrationService");
        }
        String localVarPath = "/api/v1/integration/pagerduty/configuration/services";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createPagerDutyIntegrationService");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<PagerDutyServiceName> localVarReturnType = new GenericType<PagerDutyServiceName>(){};
        return this.apiClient.invokeAPI("PagerDutyIntegrationApi.createPagerDutyIntegrationService", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIcreatePagerDutyIntegrationServiceRequest createPagerDutyIntegrationService() throws ApiException {
        return new APIcreatePagerDutyIntegrationServiceRequest();
    }

    private ApiResponse<Void> deletePagerDutyIntegrationServiceWithHttpInfo(String serviceName) throws ApiException {
        Object localVarPostBody = null;
        if (serviceName == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceName' when calling deletePagerDutyIntegrationService");
        }
        String localVarPath = "/api/v1/integration/pagerduty/configuration/services/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deletePagerDutyIntegrationService");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("PagerDutyIntegrationApi.deletePagerDutyIntegrationService", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public APIdeletePagerDutyIntegrationServiceRequest deletePagerDutyIntegrationService(String serviceName) throws ApiException {
        return new APIdeletePagerDutyIntegrationServiceRequest(serviceName);
    }

    private ApiResponse<PagerDutyServiceName> getPagerDutyIntegrationServiceWithHttpInfo(String serviceName) throws ApiException {
        Object localVarPostBody = null;
        if (serviceName == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceName' when calling getPagerDutyIntegrationService");
        }
        String localVarPath = "/api/v1/integration/pagerduty/configuration/services/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getPagerDutyIntegrationService");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<PagerDutyServiceName> localVarReturnType = new GenericType<PagerDutyServiceName>(){};
        return this.apiClient.invokeAPI("PagerDutyIntegrationApi.getPagerDutyIntegrationService", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetPagerDutyIntegrationServiceRequest getPagerDutyIntegrationService(String serviceName) throws ApiException {
        return new APIgetPagerDutyIntegrationServiceRequest(serviceName);
    }

    private ApiResponse<Void> updatePagerDutyIntegrationServiceWithHttpInfo(String serviceName, PagerDutyServiceKey body) throws ApiException {
        PagerDutyServiceKey localVarPostBody = body;
        if (serviceName == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceName' when calling updatePagerDutyIntegrationService");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePagerDutyIntegrationService");
        }
        String localVarPath = "/api/v1/integration/pagerduty/configuration/services/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updatePagerDutyIntegrationService");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("PagerDutyIntegrationApi.updatePagerDutyIntegrationService", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public APIupdatePagerDutyIntegrationServiceRequest updatePagerDutyIntegrationService(String serviceName) throws ApiException {
        return new APIupdatePagerDutyIntegrationServiceRequest(serviceName);
    }

    public class APIupdatePagerDutyIntegrationServiceRequest {
        private String serviceName;
        private PagerDutyServiceKey body;

        private APIupdatePagerDutyIntegrationServiceRequest(String serviceName) {
            this.serviceName = serviceName;
        }

        public APIupdatePagerDutyIntegrationServiceRequest body(PagerDutyServiceKey body) {
            this.body = body;
            return this;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return PagerDutyIntegrationApi.this.updatePagerDutyIntegrationServiceWithHttpInfo(this.serviceName, this.body);
        }
    }

    public class APIgetPagerDutyIntegrationServiceRequest {
        private String serviceName;

        private APIgetPagerDutyIntegrationServiceRequest(String serviceName) {
            this.serviceName = serviceName;
        }

        public PagerDutyServiceName execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<PagerDutyServiceName> executeWithHttpInfo() throws ApiException {
            return PagerDutyIntegrationApi.this.getPagerDutyIntegrationServiceWithHttpInfo(this.serviceName);
        }
    }

    public class APIdeletePagerDutyIntegrationServiceRequest {
        private String serviceName;

        private APIdeletePagerDutyIntegrationServiceRequest(String serviceName) {
            this.serviceName = serviceName;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return PagerDutyIntegrationApi.this.deletePagerDutyIntegrationServiceWithHttpInfo(this.serviceName);
        }
    }

    public class APIcreatePagerDutyIntegrationServiceRequest {
        private PagerDutyService body;

        private APIcreatePagerDutyIntegrationServiceRequest() {
        }

        public APIcreatePagerDutyIntegrationServiceRequest body(PagerDutyService body) {
            this.body = body;
            return this;
        }

        public PagerDutyServiceName execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<PagerDutyServiceName> executeWithHttpInfo() throws ApiException {
            return PagerDutyIntegrationApi.this.createPagerDutyIntegrationServiceWithHttpInfo(this.body);
        }
    }
}

