/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.auth;

import com.databricks.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.oauth.Token;
import com.databricks.internal.sdk.core.oauth.TokenCache;
import com.databricks.internal.sdk.core.utils.SerDeUtils;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptedFileTokenCache
implements TokenCache {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(EncryptedFileTokenCache.class);
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String SECRET_KEY_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final byte[] SALT = "DatabricksJdbcTokenCache".getBytes();
    private static final int ITERATION_COUNT = 65536;
    private static final int KEY_LENGTH = 256;
    private static final int IV_SIZE = 16;
    private final Path cacheFile;
    private final ObjectMapper mapper;
    private final String passphrase;

    public EncryptedFileTokenCache(Path cacheFilePath, String passphrase) {
        Objects.requireNonNull(cacheFilePath, "cacheFilePath must be defined");
        Objects.requireNonNull(passphrase, "passphrase must be defined for encrypted token cache");
        this.cacheFile = cacheFilePath;
        this.mapper = SerDeUtils.createMapper();
        this.passphrase = passphrase;
    }

    @Override
    public void save(Token token) throws DatabricksException {
        try {
            Files.createDirectories(this.cacheFile.getParent(), new FileAttribute[0]);
            String json = this.mapper.writeValueAsString(token);
            byte[] dataToWrite = json.getBytes(StandardCharsets.UTF_8);
            dataToWrite = this.encrypt(dataToWrite);
            Files.write(this.cacheFile, dataToWrite, new OpenOption[0]);
            File file = this.cacheFile.toFile();
            file.setReadable(false, false);
            file.setReadable(true, true);
            file.setWritable(false, false);
            file.setWritable(true, true);
            LOGGER.debug("Successfully saved encrypted token to cache: %s", this.cacheFile);
        }
        catch (Exception e) {
            throw new DatabricksException("Failed to save token cache: " + e.getMessage(), e);
        }
    }

    @Override
    public Token load() {
        try {
            byte[] decodedContent;
            if (!Files.exists(this.cacheFile, new LinkOption[0])) {
                LOGGER.debug("No token cache file found at: %s", this.cacheFile);
                return null;
            }
            byte[] fileContent = Files.readAllBytes(this.cacheFile);
            try {
                decodedContent = this.decrypt(fileContent);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to decrypt token cache: %s", e.getMessage());
                return null;
            }
            String json = new String(decodedContent, StandardCharsets.UTF_8);
            Token token = this.mapper.readValue(json, Token.class);
            LOGGER.debug("Successfully loaded encrypted token from cache: %s", this.cacheFile);
            return token;
        }
        catch (Exception e) {
            LOGGER.debug("Failed to load token from cache: %s", e.getMessage());
            return null;
        }
    }

    private SecretKey generateSecretKey() throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(SECRET_KEY_ALGORITHM);
        PBEKeySpec spec = new PBEKeySpec(this.passphrase.toCharArray(), SALT, 65536, 256);
        return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), ALGORITHM);
    }

    private byte[] encrypt(byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)this.generateSecretKey(), ivSpec);
        byte[] encryptedData = cipher.doFinal(data);
        byte[] combined = new byte[iv.length + encryptedData.length];
        System.arraycopy(iv, 0, combined, 0, iv.length);
        System.arraycopy(encryptedData, 0, combined, iv.length, encryptedData.length);
        return Base64.getEncoder().encode(combined);
    }

    private byte[] decrypt(byte[] encryptedData) throws Exception {
        byte[] decodedData = Base64.getDecoder().decode(encryptedData);
        byte[] iv = new byte[16];
        byte[] actualData = new byte[decodedData.length - 16];
        System.arraycopy(decodedData, 0, iv, 0, 16);
        System.arraycopy(decodedData, 16, actualData, 0, actualData.length);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)this.generateSecretKey(), ivSpec);
        return cipher.doFinal(actualData);
    }
}

