/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.jdbc.api.impl.ComplexDataTypeParser;
import com.databricks.jdbc.api.impl.IExecutionResult;
import com.databricks.jdbc.api.impl.arrow.ArrowResultChunkIterator;
import com.databricks.jdbc.api.impl.arrow.ChunkProvider;
import com.databricks.jdbc.api.impl.arrow.InlineChunkProvider;
import com.databricks.jdbc.api.impl.arrow.RemoteChunkProvider;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.CompressionCodec;
import com.databricks.jdbc.common.util.DatabricksThriftUtil;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpClientFactory;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TColumnDesc;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetResultSetMetadataResp;
import com.databricks.jdbc.model.core.ColumnInfo;
import com.databricks.jdbc.model.core.ColumnInfoTypeName;
import com.databricks.jdbc.model.core.ResultData;
import com.databricks.jdbc.model.core.ResultManifest;
import java.util.ArrayList;
import java.util.List;

public class ArrowStreamResult
implements IExecutionResult {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(ArrowStreamResult.class);
    private final ChunkProvider chunkProvider;
    private long currentRowIndex = -1L;
    private boolean isClosed;
    private ArrowResultChunkIterator chunkIterator;
    private List<ColumnInfo> columnInfos;
    private final IDatabricksSession session;

    public ArrowStreamResult(ResultManifest resultManifest, ResultData resultData, StatementId statementId, IDatabricksSession session) throws DatabricksSQLException {
        this(resultManifest, resultData, statementId, session, DatabricksHttpClientFactory.getInstance().getClient(session.getConnectionContext()));
    }

    @VisibleForTesting
    ArrowStreamResult(ResultManifest resultManifest, ResultData resultData, StatementId statementId, IDatabricksSession session, IDatabricksHttpClient httpClient) throws DatabricksSQLException {
        boolean isInlineArrow;
        this.session = session;
        boolean bl = isInlineArrow = resultData.getAttachment() != null;
        if (isInlineArrow) {
            LOGGER.debug("Creating ArrowStreamResult with inline attachment for statementId: {}", statementId.toSQLExecStatementId());
            this.chunkProvider = new InlineChunkProvider(resultData, resultManifest);
        } else {
            LOGGER.debug("Creating ArrowStreamResult with remote links for statementId: {}", statementId.toSQLExecStatementId());
            this.chunkProvider = new RemoteChunkProvider(statementId, resultManifest, resultData, session, httpClient, session.getConnectionContext().getCloudFetchThreadPoolSize());
        }
        this.columnInfos = resultManifest.getSchema().getColumnCount() == 0L ? new ArrayList<ColumnInfo>() : new ArrayList<ColumnInfo>(resultManifest.getSchema().getColumns());
    }

    public ArrowStreamResult(TFetchResultsResp resultsResp, boolean isInlineArrow, IDatabricksStatementInternal parentStatementId, IDatabricksSession session) throws DatabricksSQLException {
        this(resultsResp, isInlineArrow, parentStatementId, session, DatabricksHttpClientFactory.getInstance().getClient(session.getConnectionContext()));
    }

    @VisibleForTesting
    ArrowStreamResult(TFetchResultsResp resultsResp, boolean isInlineArrow, IDatabricksStatementInternal parentStatement, IDatabricksSession session, IDatabricksHttpClient httpClient) throws DatabricksSQLException {
        this.session = session;
        this.setColumnInfo(resultsResp.getResultSetMetadata());
        if (isInlineArrow) {
            this.chunkProvider = new InlineChunkProvider(resultsResp, parentStatement, session);
        } else {
            CompressionCodec compressionCodec = CompressionCodec.getCompressionMapping(resultsResp.getResultSetMetadata());
            this.chunkProvider = new RemoteChunkProvider(parentStatement, resultsResp, session, httpClient, session.getConnectionContext().getCloudFetchThreadPoolSize(), compressionCodec);
        }
    }

    public List<String> getArrowMetadata() throws DatabricksSQLException {
        if (this.chunkProvider == null || this.chunkProvider.getChunk() == null) {
            return null;
        }
        return this.chunkProvider.getChunk().getArrowMetadata();
    }

    @Override
    public Object getObject(int columnIndex) throws DatabricksSQLException {
        boolean isComplexDatatypeSupportEnabled;
        ColumnInfoTypeName requiredType = this.columnInfos.get(columnIndex).getTypeName();
        String arrowMetadata = this.chunkIterator.getType(columnIndex);
        if (arrowMetadata == null) {
            arrowMetadata = this.columnInfos.get(columnIndex).getTypeText();
        }
        if (!(isComplexDatatypeSupportEnabled = this.session.getConnectionContext().isComplexDatatypeSupportEnabled()) && ArrowStreamResult.isComplexType(requiredType)) {
            LOGGER.debug("Complex datatype support is disabled, converting complex type to STRING");
            Object result = this.chunkIterator.getColumnObjectAtCurrentRow(columnIndex, ColumnInfoTypeName.STRING, "STRING", this.columnInfos.get(columnIndex));
            if (result == null) {
                return null;
            }
            ComplexDataTypeParser parser = new ComplexDataTypeParser();
            return parser.formatComplexTypeString(result.toString(), requiredType.name(), arrowMetadata);
        }
        return this.chunkIterator.getColumnObjectAtCurrentRow(columnIndex, requiredType, arrowMetadata, this.columnInfos.get(columnIndex));
    }

    @VisibleForTesting
    public static boolean isComplexType(ColumnInfoTypeName type) {
        return type == ColumnInfoTypeName.ARRAY || type == ColumnInfoTypeName.MAP || type == ColumnInfoTypeName.STRUCT;
    }

    @Override
    public long getCurrentRow() {
        return this.currentRowIndex;
    }

    @Override
    public boolean next() throws DatabricksSQLException {
        if (!this.hasNext()) {
            return false;
        }
        ++this.currentRowIndex;
        if (this.chunkIterator == null || !this.chunkIterator.hasNextRow()) {
            this.chunkProvider.next();
            this.chunkIterator = this.chunkProvider.getChunk().getChunkIterator();
        }
        return this.chunkIterator.nextRow();
    }

    @Override
    public boolean hasNext() {
        if (this.isClosed) {
            return false;
        }
        if (this.chunkIterator != null && this.chunkIterator.hasNextRow()) {
            return true;
        }
        return this.chunkProvider.hasNextChunk();
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.chunkProvider.close();
    }

    @Override
    public long getRowCount() {
        return this.chunkProvider.getRowCount();
    }

    @Override
    public long getChunkCount() {
        return this.chunkProvider.getChunkCount();
    }

    private void setColumnInfo(TGetResultSetMetadataResp resultManifest) {
        this.columnInfos = new ArrayList<ColumnInfo>();
        if (resultManifest.getSchema() == null) {
            return;
        }
        for (TColumnDesc tColumnDesc : resultManifest.getSchema().getColumns()) {
            this.columnInfos.add(DatabricksThriftUtil.getColumnInfoFromTColumnDesc(tColumnDesc));
        }
    }
}

