/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.mixin;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.files.AddBlock;
import com.databricks.internal.sdk.service.files.Close;
import com.databricks.internal.sdk.service.files.Create;
import com.databricks.internal.sdk.service.files.CreateResponse;
import com.databricks.internal.sdk.service.files.DbfsAPI;
import com.databricks.internal.sdk.service.files.DbfsService;
import com.databricks.internal.sdk.service.files.FileInfo;
import com.databricks.internal.sdk.service.files.ReadDbfsRequest;
import com.databricks.internal.sdk.service.files.ReadResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

public class DbfsExt
extends DbfsAPI {
    public DbfsExt(ApiClient apiClient) {
        super(apiClient);
    }

    public DbfsExt(DbfsService mock) {
        super(mock);
    }

    public InputStream open(final String path) {
        return new InputStream(){
            private long offset = 0L;
            private byte[] buffer = new byte[0];
            private int bufferOffset = 0;

            @Override
            public int read() {
                byte b;
                if (this.bufferOffset >= this.buffer.length) {
                    ReadDbfsRequest request = new ReadDbfsRequest().setPath(path).setOffset(this.offset).setLength(0x100000L);
                    ReadResponse response = DbfsExt.this.read(request);
                    this.buffer = Base64.getDecoder().decode(response.getData());
                    this.bufferOffset = 0;
                    this.offset += (long)this.buffer.length;
                }
                if (this.bufferOffset >= this.buffer.length) {
                    return -1;
                }
                if ((b = this.buffer[this.bufferOffset++]) == -1) {
                    return 255;
                }
                return b;
            }
        };
    }

    public byte[] readAllBytes(Path path) throws IOException {
        try (InputStream in = this.open(path.toString());){
            int result;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[0x100000];
            do {
                if ((result = in.read(buffer)) <= 0) continue;
                out.write(buffer, 0, result);
            } while (result >= 0);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public List<String> readAllLines(Path path, Charset cs) throws IOException {
        byte[] bytes = this.readAllBytes(path);
        CharBuffer charBuffer = cs.decode(ByteBuffer.wrap(bytes));
        ArrayList<String> lines = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < charBuffer.length(); ++i) {
            if (charBuffer.charAt(i) != '\n') continue;
            lines.add(charBuffer.subSequence(start, i).toString());
            start = i + 1;
        }
        return lines;
    }

    public OutputStream getOutputStream(String path) {
        CreateResponse createResponse = this.create(new Create().setPath(path).setOverwrite(true));
        final long handle = createResponse.getHandle();
        return new OutputStream(){
            private final byte[] buffer = new byte[0x100000];
            private int bufferOffset = 0;

            @Override
            public void write(int b) {
                this.buffer[this.bufferOffset++] = (byte)b;
                if (this.bufferOffset >= this.buffer.length) {
                    this.flush();
                }
            }

            @Override
            public void flush() {
                if (this.bufferOffset > 0) {
                    byte[] remainingBytes = Arrays.copyOfRange(this.buffer, 0, this.bufferOffset);
                    DbfsExt.this.addBlock(new AddBlock().setHandle(handle).setData(Base64.getEncoder().encodeToString(remainingBytes)));
                    this.bufferOffset = 0;
                }
            }

            @Override
            public void close() {
                this.flush();
                DbfsExt.this.close(new Close().setHandle(handle));
            }
        };
    }

    public Path write(Path path, byte[] bytes) throws IOException {
        try (OutputStream out = this.getOutputStream(path.toString());){
            out.write(bytes);
        }
        return path;
    }

    public Iterable<FileInfo> recursiveList(String path) {
        return () -> new LazyDirectoryIterator(path);
    }

    private class LazyDirectoryIterator
    implements Iterator<FileInfo> {
        private final Queue<String> dirsToVisit = new ArrayDeque<String>();
        private Iterator<FileInfo> currentFiles;

        public LazyDirectoryIterator(String path) {
            this.dirsToVisit.add(path);
            this.currentFiles = Collections.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            while (!this.currentFiles.hasNext() && !this.dirsToVisit.isEmpty()) {
                String nextDir = this.dirsToVisit.remove();
                this.currentFiles = DbfsExt.this.list(nextDir).iterator();
            }
            return this.currentFiles.hasNext();
        }

        @Override
        public FileInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            FileInfo nextFile = this.currentFiles.next();
            if (nextFile.getIsDir().booleanValue()) {
                this.dirsToVisit.add(nextFile.getPath());
            }
            return nextFile;
        }
    }
}

