/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.aeprocessor.AEQColumnName;
import com.databricks.client.sqlengine.aeprocessor.AEQTableName;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.IETNode;
import com.databricks.client.sqlengine.executor.etree.IETNodeVisitor;
import com.databricks.client.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.support.exceptions.ErrorException;

public class ETColumnRef
extends ETValueExpr {
    private ETRelationalExpr m_rel;
    private int m_colNum;
    private final boolean m_isOuterRef;

    public ETColumnRef(ETRelationalExpr eTRelationalExpr, int n, boolean bl) {
        assert (null != eTRelationalExpr);
        this.m_rel = eTRelationalExpr;
        this.m_colNum = n;
        this.m_isOuterRef = bl;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public void close(boolean bl) {
    }

    public int getColumnNumber() {
        return this.m_colNum;
    }

    @Override
    public String getLogString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(": ");
        IColumn iColumn = this.m_rel.getColumn(this.m_colNum);
        AEQColumnName aEQColumnName = new AEQColumnName(new AEQTableName(iColumn.getCatalogName(), iColumn.getSchemaName(), iColumn.getTableName()), iColumn.getName());
        stringBuilder.append(aEQColumnName.toString());
        return stringBuilder.toString();
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    public ETRelationalExpr getRelationalExpression() {
        return this.m_rel;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    public boolean isOuterReference() {
        return this.m_isOuterRef;
    }

    @Override
    public void open() {
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        return this.m_rel.retrieveData(this.m_colNum, eTDataRequest);
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }
}

