/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEAggrFn;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.IETNode;
import com.databricks.client.sqlengine.executor.etree.IETNodeVisitor;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExprList;
import com.databricks.client.sqlengine.executor.etree.value.aggregatefn.IAggregator;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.List;

public class ETAggregateFn
extends ETValueExpr {
    private AEAggrFn.AggrFnId m_functionId;
    private IAggregator m_aggregator;
    private final ETValueUpdateParameters m_updateParameters;
    private ETValueExprList m_operands;
    private boolean m_isOpen = false;

    public ETAggregateFn(AEAggrFn.AggrFnId aggrFnId, ETValueExprList eTValueExprList, List<? extends IColumn> list, IAggregator iAggregator) {
        this.m_functionId = aggrFnId;
        this.m_aggregator = iAggregator;
        this.m_updateParameters = new ETValueUpdateParameters(eTValueExprList, list.toArray(new IColumn[0]));
        this.m_operands = eTValueExprList;
    }

    @Override
    public void close(boolean bl) {
        this.m_operands.close(bl);
        this.m_isOpen = false;
    }

    @Override
    public boolean isOpen() {
        return this.m_isOpen;
    }

    @Override
    public void reset() throws ErrorException {
        this.m_operands.reset();
        this.m_aggregator.reset();
    }

    @Override
    public String getLogString() {
        return super.getLogString() + ": " + (Object)((Object)this.m_functionId);
    }

    @Override
    public void update() throws ErrorException {
        this.m_aggregator.update(this.m_updateParameters);
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return this.m_operands.getNumChildren();
    }

    @Override
    public void open() throws ErrorException {
        this.m_operands.open();
        this.m_aggregator.reset();
        this.m_isOpen = true;
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        return this.m_aggregator.retrieveData(eTDataRequest);
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        super.registerWarningListener(iWarningListener);
        this.m_aggregator.registerWarningListener(iWarningListener);
    }

    protected IAggregator.IUpdateParameters getValueUpdateParameters() {
        return this.m_updateParameters;
    }

    protected IAggregator getAggregator() {
        return this.m_aggregator;
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        return this.m_operands.getChild(n);
    }

    private static class ETValueUpdateParameters
    implements IAggregator.IUpdateParameters {
        private boolean[] m_hasMoreData;
        private ETDataRequest[] m_dataRequest;
        private ETValueExprList m_valueExprs;
        private IColumn[] m_inputMetadata;

        public ETValueUpdateParameters(ETValueExprList eTValueExprList, IColumn[] iColumnArray) {
            this.m_valueExprs = eTValueExprList;
            this.m_inputMetadata = iColumnArray;
            this.m_dataRequest = new ETDataRequest[iColumnArray.length];
            for (int i = 0; i < iColumnArray.length; ++i) {
                this.m_dataRequest[i] = new ETDataRequest(iColumnArray[i]);
            }
            this.m_hasMoreData = new boolean[iColumnArray.length];
        }

        @Override
        public ISqlDataWrapper getData(int n) throws ErrorException {
            ETDataRequest eTDataRequest = this.m_dataRequest[n];
            eTDataRequest.setOffset(0L);
            eTDataRequest.setMaxBytes(-1L);
            eTDataRequest.getData().setNull();
            this.m_hasMoreData[n] = this.m_valueExprs.retrieveData(n, eTDataRequest);
            return eTDataRequest.getData();
        }

        @Override
        public ISqlDataWrapper getData(int n, long l, long l2) throws ErrorException {
            ETDataRequest eTDataRequest = this.m_dataRequest[n];
            eTDataRequest.setOffset(l);
            eTDataRequest.setMaxBytes(l2);
            eTDataRequest.getData().setNull();
            this.m_hasMoreData[n] = this.m_valueExprs.retrieveData(n, eTDataRequest);
            return eTDataRequest.getData();
        }

        @Override
        public IColumn getMetadata(int n) {
            return this.m_inputMetadata[n];
        }

        @Override
        public boolean hasMoreData(int n) {
            return this.m_hasMoreData[n];
        }
    }
}

