/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift;

import com.databricks.client.jdbc42.internal.apache.thrift.TBase;
import com.databricks.client.jdbc42.internal.apache.thrift.TBaseHelper;
import com.databricks.client.jdbc42.internal.apache.thrift.TException;
import com.databricks.client.jdbc42.internal.apache.thrift.TFieldIdEnum;
import com.databricks.client.jdbc42.internal.apache.thrift.annotation.Nullable;
import com.databricks.client.jdbc42.internal.apache.thrift.meta_data.FieldMetaData;
import com.databricks.client.jdbc42.internal.apache.thrift.meta_data.FieldValueMetaData;
import com.databricks.client.jdbc42.internal.apache.thrift.meta_data.ListMetaData;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TCompactProtocol;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TField;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TList;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TProtocolException;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TProtocolUtil;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TStruct;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TTupleProtocol;
import com.databricks.client.jdbc42.internal.apache.thrift.scheme.IScheme;
import com.databricks.client.jdbc42.internal.apache.thrift.scheme.SchemeFactory;
import com.databricks.client.jdbc42.internal.apache.thrift.scheme.StandardScheme;
import com.databricks.client.jdbc42.internal.apache.thrift.scheme.TupleScheme;
import com.databricks.client.jdbc42.internal.apache.thrift.transport.TIOStreamTransport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TStringColumn
implements TBase<TStringColumn, _Fields>,
Serializable,
Cloneable,
Comparable<TStringColumn> {
    private static final TStruct STRUCT_DESC = new TStruct("TStringColumn");
    private static final TField VALUES_FIELD_DESC = new TField("values", 15, 1);
    private static final TField NULLS_FIELD_DESC = new TField("nulls", 11, 2);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TStringColumnStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TStringColumnTupleSchemeFactory();
    @Nullable
    private List<String> values;
    @Nullable
    private ByteBuffer nulls;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TStringColumn() {
    }

    public TStringColumn(List<String> list, ByteBuffer byteBuffer) {
        this();
        this.values = list;
        this.nulls = TBaseHelper.copyBinary(byteBuffer);
    }

    public TStringColumn(TStringColumn tStringColumn) {
        if (tStringColumn.isSetValues()) {
            ArrayList<String> arrayList = new ArrayList<String>(tStringColumn.values);
            this.values = arrayList;
        }
        if (tStringColumn.isSetNulls()) {
            this.nulls = TBaseHelper.copyBinary(tStringColumn.nulls);
        }
    }

    @Override
    public TStringColumn deepCopy() {
        return new TStringColumn(this);
    }

    @Override
    public void clear() {
        this.values = null;
        this.nulls = null;
    }

    public int getValuesSize() {
        return this.values == null ? 0 : this.values.size();
    }

    @Nullable
    public Iterator<String> getValuesIterator() {
        return this.values == null ? null : this.values.iterator();
    }

    public void addToValues(String string) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(string);
    }

    @Nullable
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(@Nullable List<String> list) {
        this.values = list;
    }

    public void unsetValues() {
        this.values = null;
    }

    public boolean isSetValues() {
        return this.values != null;
    }

    public void setValuesIsSet(boolean bl) {
        if (!bl) {
            this.values = null;
        }
    }

    public byte[] getNulls() {
        this.setNulls(TBaseHelper.rightSize(this.nulls));
        return this.nulls == null ? null : this.nulls.array();
    }

    public ByteBuffer bufferForNulls() {
        return TBaseHelper.copyBinary(this.nulls);
    }

    public void setNulls(byte[] byArray) {
        this.nulls = byArray == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])byArray.clone());
    }

    public void setNulls(@Nullable ByteBuffer byteBuffer) {
        this.nulls = TBaseHelper.copyBinary(byteBuffer);
    }

    public void unsetNulls() {
        this.nulls = null;
    }

    public boolean isSetNulls() {
        return this.nulls != null;
    }

    public void setNullsIsSet(boolean bl) {
        if (!bl) {
            this.nulls = null;
        }
    }

    @Override
    public void setFieldValue(_Fields _Fields2, @Nullable Object object) {
        switch (_Fields2) {
            case VALUES: {
                if (object == null) {
                    this.unsetValues();
                    break;
                }
                this.setValues((List)object);
                break;
            }
            case NULLS: {
                if (object == null) {
                    this.unsetNulls();
                    break;
                }
                if (object instanceof byte[]) {
                    this.setNulls((byte[])object);
                    break;
                }
                this.setNulls((ByteBuffer)object);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields _Fields2) {
        switch (_Fields2) {
            case VALUES: {
                return this.getValues();
            }
            case NULLS: {
                return this.getNulls();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields _Fields2) {
        if (_Fields2 == null) {
            throw new IllegalArgumentException();
        }
        switch (_Fields2) {
            case VALUES: {
                return this.isSetValues();
            }
            case NULLS: {
                return this.isSetNulls();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TStringColumn) {
            return this.equals((TStringColumn)object);
        }
        return false;
    }

    public boolean equals(TStringColumn tStringColumn) {
        if (tStringColumn == null) {
            return false;
        }
        if (this == tStringColumn) {
            return true;
        }
        boolean bl = this.isSetValues();
        boolean bl2 = tStringColumn.isSetValues();
        if (bl || bl2) {
            if (!bl || !bl2) {
                return false;
            }
            if (!this.values.equals(tStringColumn.values)) {
                return false;
            }
        }
        boolean bl3 = this.isSetNulls();
        boolean bl4 = tStringColumn.isSetNulls();
        if (bl3 || bl4) {
            if (!bl3 || !bl4) {
                return false;
            }
            if (!this.nulls.equals(tStringColumn.nulls)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        n = n * 8191 + (this.isSetValues() ? 131071 : 524287);
        if (this.isSetValues()) {
            n = n * 8191 + this.values.hashCode();
        }
        n = n * 8191 + (this.isSetNulls() ? 131071 : 524287);
        if (this.isSetNulls()) {
            n = n * 8191 + this.nulls.hashCode();
        }
        return n;
    }

    @Override
    public int compareTo(TStringColumn tStringColumn) {
        if (!this.getClass().equals(tStringColumn.getClass())) {
            return this.getClass().getName().compareTo(tStringColumn.getClass().getName());
        }
        int n = 0;
        n = Boolean.valueOf(this.isSetValues()).compareTo(tStringColumn.isSetValues());
        if (n != 0) {
            return n;
        }
        if (this.isSetValues() && (n = TBaseHelper.compareTo(this.values, tStringColumn.values)) != 0) {
            return n;
        }
        n = Boolean.valueOf(this.isSetNulls()).compareTo(tStringColumn.isSetNulls());
        if (n != 0) {
            return n;
        }
        if (this.isSetNulls() && (n = TBaseHelper.compareTo(this.nulls, tStringColumn.nulls)) != 0) {
            return n;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int n) {
        return _Fields.findByThriftId(n);
    }

    @Override
    public void read(TProtocol tProtocol) throws TException {
        TStringColumn.scheme(tProtocol).read(tProtocol, (TStringColumn)this);
    }

    @Override
    public void write(TProtocol tProtocol) throws TException {
        TStringColumn.scheme(tProtocol).write(tProtocol, (TStringColumn)this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TStringColumn(");
        boolean bl = true;
        stringBuilder.append("values:");
        if (this.values == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(this.values);
        }
        bl = false;
        if (!bl) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("nulls:");
        if (this.nulls == null) {
            stringBuilder.append("null");
        } else {
            TBaseHelper.toString(this.nulls, stringBuilder);
        }
        bl = false;
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void validate() throws TException {
        if (!this.isSetValues()) {
            throw new TProtocolException("Required field 'values' is unset! Struct:" + this.toString());
        }
        if (!this.isSetNulls()) {
            throw new TProtocolException("Required field 'nulls' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(objectOutputStream)));
        }
        catch (TException tException) {
            throw new IOException(tException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(objectInputStream)));
        }
        catch (TException tException) {
            throw new IOException(tException);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol tProtocol) {
        return (StandardScheme.class.equals(tProtocol.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> enumMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        enumMap.put(_Fields.VALUES, new FieldMetaData("values", 1, new ListMetaData(15, new FieldValueMetaData(11))));
        enumMap.put(_Fields.NULLS, new FieldMetaData("nulls", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(enumMap);
        FieldMetaData.addStructMetaDataMap(TStringColumn.class, metaDataMap);
    }

    private static class TStringColumnTupleScheme
    extends TupleScheme<TStringColumn> {
        private TStringColumnTupleScheme() {
        }

        @Override
        public void write(TProtocol tProtocol, TStringColumn tStringColumn) throws TException {
            TTupleProtocol tTupleProtocol = (TTupleProtocol)tProtocol;
            tTupleProtocol.writeI32(tStringColumn.values.size());
            for (String string : tStringColumn.values) {
                tTupleProtocol.writeString(string);
            }
            tTupleProtocol.writeBinary(tStringColumn.nulls);
        }

        @Override
        public void read(TProtocol tProtocol, TStringColumn tStringColumn) throws TException {
            TTupleProtocol tTupleProtocol = (TTupleProtocol)tProtocol;
            TList tList = new TList(11, tTupleProtocol.readI32());
            tStringColumn.values = new ArrayList(tList.size);
            for (int i = 0; i < tList.size; ++i) {
                String string = tTupleProtocol.readString();
                tStringColumn.values.add(string);
            }
            tStringColumn.setValuesIsSet(true);
            tStringColumn.nulls = tTupleProtocol.readBinary();
            tStringColumn.setNullsIsSet(true);
        }
    }

    private static class TStringColumnTupleSchemeFactory
    implements SchemeFactory {
        private TStringColumnTupleSchemeFactory() {
        }

        public TStringColumnTupleScheme getScheme() {
            return new TStringColumnTupleScheme();
        }
    }

    private static class TStringColumnStandardScheme
    extends StandardScheme<TStringColumn> {
        private TStringColumnStandardScheme() {
        }

        @Override
        public void read(TProtocol tProtocol, TStringColumn tStringColumn) throws TException {
            tProtocol.readStructBegin();
            while (true) {
                TField tField = tProtocol.readFieldBegin();
                if (tField.type == 0) break;
                switch (tField.id) {
                    case 1: {
                        if (tField.type == 15) {
                            TList tList = tProtocol.readListBegin();
                            tStringColumn.values = new ArrayList(tList.size);
                            for (int i = 0; i < tList.size; ++i) {
                                String string = tProtocol.readString();
                                tStringColumn.values.add(string);
                            }
                            tProtocol.readListEnd();
                            tStringColumn.setValuesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(tProtocol, tField.type);
                        break;
                    }
                    case 2: {
                        if (tField.type == 11) {
                            tStringColumn.nulls = tProtocol.readBinary();
                            tStringColumn.setNullsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(tProtocol, tField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(tProtocol, tField.type);
                    }
                }
                tProtocol.readFieldEnd();
            }
            tProtocol.readStructEnd();
            tStringColumn.validate();
        }

        @Override
        public void write(TProtocol tProtocol, TStringColumn tStringColumn) throws TException {
            tStringColumn.validate();
            tProtocol.writeStructBegin(STRUCT_DESC);
            if (tStringColumn.values != null) {
                tProtocol.writeFieldBegin(VALUES_FIELD_DESC);
                tProtocol.writeListBegin(new TList(11, tStringColumn.values.size()));
                for (String string : tStringColumn.values) {
                    tProtocol.writeString(string);
                }
                tProtocol.writeListEnd();
                tProtocol.writeFieldEnd();
            }
            if (tStringColumn.nulls != null) {
                tProtocol.writeFieldBegin(NULLS_FIELD_DESC);
                tProtocol.writeBinary(tStringColumn.nulls);
                tProtocol.writeFieldEnd();
            }
            tProtocol.writeFieldStop();
            tProtocol.writeStructEnd();
        }
    }

    private static class TStringColumnStandardSchemeFactory
    implements SchemeFactory {
        private TStringColumnStandardSchemeFactory() {
        }

        public TStringColumnStandardScheme getScheme() {
            return new TStringColumnStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        VALUES(1, "values"),
        NULLS(2, "nulls");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int n) {
            switch (n) {
                case 1: {
                    return VALUES;
                }
                case 2: {
                    return NULLS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int n) {
            _Fields _Fields2 = _Fields.findByThriftId(n);
            if (_Fields2 == null) {
                throw new IllegalArgumentException("Field " + n + " doesn't exist!");
            }
            return _Fields2;
        }

        @Nullable
        public static _Fields findByName(String string) {
            return byName.get(string);
        }

        private _Fields(short s, String string2) {
            this._thriftId = s;
            this._fieldName = string2;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields _Fields2 : EnumSet.allOf(_Fields.class)) {
                byName.put(_Fields2.getFieldName(), _Fields2);
            }
        }
    }
}

