/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.databricks.client.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class SignedTinyIntJDBCDataSink
extends NumberJDBCDataSink<Byte> {
    public SignedTinyIntJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException, ConversionFailed {
        if (object == null || object instanceof Byte) {
            this.doSet((Byte)object);
        } else if (object instanceof Number) {
            byte by = NonTrivialJDBCConversions.objectToByte(object, this.getAndClearListener());
            this.handleConversionResult(object, "set");
            this.doSet(by);
        } else {
            throw new IncorrectTypeException();
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.doSet(by);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        byte by = NonTrivialJDBCConversions.LongConverter.toByte(s, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(s, "setShort");
        }
        this.setByte(by);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        byte by = NonTrivialJDBCConversions.LongConverter.toByte(n, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(n, "setInt");
        }
        this.setByte(by);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        byte by = NonTrivialJDBCConversions.LongConverter.toByte(l, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(l, "setLong");
        }
        this.setByte(by);
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        byte by = NonTrivialJDBCConversions.DoubleConverter.toByte(f, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(Float.valueOf(f), "setFloat");
        }
        this.setByte(by);
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        byte by = NonTrivialJDBCConversions.DoubleConverter.toByte(d, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(d, "setDouble");
        }
        this.setByte(by);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            byte by = NonTrivialJDBCConversions.DecimalConverter.toByte(bigDecimal, this.getAndClearListener());
            this.handleConversionResult(bigDecimal, "setBigDecimal");
            this.setByte(by);
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            string = string.trim();
            try {
                this.setByte(Byte.parseByte(string));
            }
            catch (NumberFormatException numberFormatException) {
                byte by = NonTrivialJDBCConversions.DecimalConverter.toByte(NonTrivialJDBCConversions.stringToBigDecimal(string), this.getAndClearListener());
                this.handleConversionResult(string, "setString");
                this.setByte(by);
            }
        }
    }
}

