/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.databricks.client.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.databricks.client.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public abstract class BinaryJDBCDataSource
extends ConvertingJDBCDataSource {
    public BinaryJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    public abstract byte[] get() throws ErrorException;

    @Override
    public Reader getAsReader() throws IncorrectTypeException, ConversionFailed, ErrorException {
        InputStream inputStream = this.getAsInputStream();
        if (inputStream == null) {
            return null;
        }
        return new NonTrivialJDBCConversions.HexStringReader(inputStream, true);
    }

    @Override
    public InputStream getAsInputStream() throws ErrorException {
        byte[] byArray = this.get();
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        byte[] byArray = this.get();
        if (byArray == null) {
            return null;
        }
        return NonTrivialJDBCConversions.bytesToHex(byArray);
    }

    @Override
    public byte[] getBytes() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.get();
    }

    @Override
    protected boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        int n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        switch (n) {
            case 2000: {
                return true;
            }
        }
        return this.isCharType(n) || this.isBinaryType(n);
    }
}

