/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.slider.library.Transformers;

import android.view.View;
import com.daimajia.slider.library.Transformers.BaseTransformer;
import com.nineoldandroids.view.ViewHelper;

public class ZoomOutSlideTransformer
extends BaseTransformer {
    private static final float MIN_SCALE = 0.85f;
    private static final float MIN_ALPHA = 0.5f;

    @Override
    protected void onTransform(View view, float position) {
        if (position >= -1.0f || position <= 1.0f) {
            float height = view.getHeight();
            float scaleFactor = Math.max(0.85f, 1.0f - Math.abs(position));
            float vertMargin = height * (1.0f - scaleFactor) / 2.0f;
            float horzMargin = (float)view.getWidth() * (1.0f - scaleFactor) / 2.0f;
            ViewHelper.setPivotY((View)view, (float)(0.5f * height));
            if (position < 0.0f) {
                ViewHelper.setTranslationX((View)view, (float)(horzMargin - vertMargin / 2.0f));
            } else {
                ViewHelper.setTranslationX((View)view, (float)(-horzMargin + vertMargin / 2.0f));
            }
            ViewHelper.setScaleX((View)view, (float)scaleFactor);
            ViewHelper.setScaleY((View)view, (float)scaleFactor);
            ViewHelper.setAlpha((View)view, (float)(0.5f + (scaleFactor - 0.85f) / 0.14999998f * 0.5f));
        }
    }
}

